/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io.file;

import com.buession.core.utils.StringUtils;
import com.buession.io.MimeType;
import com.buession.io.file.DefaultMimeTypeDetector;
import com.buession.io.file.MimeTypeDetector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;

public class File
extends java.io.File {
    private static final long serialVersionUID = 1512573860637989192L;
    private static MimeTypeDetector mimeTypeDetector;
    private MimeType mimeType;
    private String extension;

    public File(java.io.File parent, String child) {
        super(parent, child);
    }

    public File(String path) {
        super(path);
    }

    public File(java.io.File file) {
        super(file.getPath());
    }

    public File(String parent, String child) {
        super(parent, child);
    }

    public File(URI uri) {
        super(uri);
    }

    public MimeType getMimeType() {
        if (this.mimeType == null) {
            if (mimeTypeDetector == null) {
                mimeTypeDetector = new DefaultMimeTypeDetector();
            }
            this.mimeType = mimeTypeDetector.probe(this.toPath());
        }
        return this.mimeType;
    }

    public byte[] read() throws IOException {
        int size = 4096;
        FileBufferedInputStream bis = new FileBufferedInputStream(this);
        byte[] tempChars = new byte[size];
        int num = 0;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        while ((num = bis.read(tempChars)) != -1) {
            for (int i = 0; i < num; ++i) {
                bytes.add(tempChars[i]);
            }
        }
        bis.close();
        Byte[] oBytes = bytes.toArray(new Byte[0]);
        byte[] result = new byte[oBytes.length];
        for (int i = 0; i < oBytes.length; ++i) {
            result[i] = oBytes[i];
        }
        return result;
    }

    public void write(String str) throws IOException {
        this.write(str.getBytes());
    }

    public void write(char[] chars) throws IOException {
        FileBufferedOutputStream bos = new FileBufferedOutputStream(this);
        for (char c : chars) {
            byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
            bos.write(b);
        }
        bos.flush();
        bos.close();
    }

    public void write(byte[] bytes) throws IOException {
        FileBufferedOutputStream bos = new FileBufferedOutputStream(this);
        bos.write(bytes);
        bos.flush();
        bos.close();
    }

    public void write(String str, boolean append) throws IOException {
        this.write(str.getBytes(), append);
    }

    public void write(char[] chars, boolean append) throws IOException {
        FileBufferedOutputStream bos = new FileBufferedOutputStream(this, append);
        for (char c : chars) {
            byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
            bos.write(b);
        }
        bos.flush();
        bos.close();
    }

    public void write(byte[] bytes, boolean append) throws IOException {
        FileBufferedOutputStream bos = new FileBufferedOutputStream(this, append);
        bos.write(bytes);
        bos.flush();
        bos.close();
    }

    public String getMd5() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath() + " not found.");
        }
        if (!this.isFile()) {
            throw new IOException(this.getPath() + " is not a file.");
        }
        FileInputStream fs = new FileInputStream(this);
        String result = DigestUtils.md5Hex((InputStream)fs);
        fs.close();
        return result;
    }

    public String getSha1() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath() + " not found.");
        }
        if (!this.isFile()) {
            throw new IOException(this.getPath() + " is not a file.");
        }
        FileInputStream fs = new FileInputStream(this);
        String result = DigestUtils.sha1Hex((InputStream)fs);
        fs.close();
        return result;
    }

    public String getExtension() throws IOException {
        if (!this.isFile()) {
            throw new IOException(this.getPath() + " is not a file.");
        }
        if (this.extension == null) {
            int i;
            String fileName = this.getName();
            this.extension = StringUtils.endsWith((CharSequence)fileName, (CharSequence)".tar.gz") ? "tar.gz" : ((i = fileName.lastIndexOf(46)) == fileName.length() - 1 ? "" : fileName.substring(i + 1).toLowerCase());
        }
        return this.extension;
    }

    public boolean rename(String newName) {
        return super.renameTo(new File(this.getParent() + '/' + newName));
    }

    private static final class FileBufferedOutputStream
    extends BufferedOutputStream {
        public FileBufferedOutputStream(java.io.File file) throws FileNotFoundException {
            super(new DataOutputStream(new FileOutputStream(file)));
        }

        public FileBufferedOutputStream(java.io.File file, boolean append) throws FileNotFoundException {
            super(new DataOutputStream(new FileOutputStream(file, append)));
        }
    }

    private static final class FileBufferedInputStream
    extends BufferedInputStream {
        public FileBufferedInputStream(java.io.File file) throws FileNotFoundException {
            super(new DataInputStream(new FileInputStream(file)));
        }
    }
}

