/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io.file;

import com.buession.core.utils.Assert;
import com.buession.io.file.FilePermission;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class Files {
    public static void changeGroup(Path path, String group) throws IOException {
        Files.chgrp(path, group);
    }

    public static void changeGroup(File file, String group) throws IOException {
        Files.chgrp(file, group);
    }

    public static void changeGroup(String path, String group) throws IOException {
        Files.chgrp(path, group);
    }

    public static void chgrp(Path path, String group) throws IOException {
        Assert.isNull((Object)path, (String)"File path cloud not be null.");
        Assert.isNull((Object)group, (String)"Group cloud not be null.");
        GroupPrincipal groupPrincipal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByGroupName(group);
        PosixFileAttributeView view = java.nio.file.Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (view == null) {
            throw new UnsupportedOperationException();
        }
        view.setGroup(groupPrincipal);
    }

    public static void chgrp(File file, String group) throws IOException {
        Assert.isNull((Object)file, (String)"File cloud not be null.");
        Files.chgrp(file.toPath(), group);
    }

    public static void chgrp(String path, String group) throws IOException {
        Assert.isBlank((String)path, (String)"File path must be contain entity string.");
        Files.chgrp(new File(path), group);
    }

    public static void changeOwner(Path path, String owner) throws IOException {
        Files.chown(path, owner);
    }

    public static void changeOwner(File file, String owner) throws IOException {
        Files.chown(file, owner);
    }

    public static void changeOwner(String path, String owner) throws IOException {
        Files.chown(path, owner);
    }

    public static void chown(Path path, String owner) throws IOException {
        Assert.isNull((Object)path, (String)"File path cloud not be null.");
        Assert.isNull((Object)owner, (String)"Owner coult not be null.");
        java.nio.file.Files.setOwner(path, FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(owner));
    }

    public static void chown(File file, String owner) throws IOException {
        Assert.isNull((Object)file, (String)"File cloud not be null.");
        Files.chown(file.toPath(), owner);
    }

    public static void chown(String path, String owner) throws IOException {
        Assert.isBlank((String)path, (String)"File path must be contain entity string.");
        Files.chown(new File(path), owner);
    }

    public static void chmod(Path path, int mode) throws IOException {
        Assert.isNull((Object)path, (String)"File path cloud not be null.");
        Files.chmod(path, Files.mode2perms(mode));
    }

    public static void chmod(File file, int mode) throws IOException {
        Assert.isNull((Object)file, (String)"File cloud not be null.");
        Files.chmod(file.toPath(), mode);
    }

    public static void chmod(String path, int mode) throws IOException {
        Assert.isBlank((String)path, (String)"File path must be contain entity string.");
        Files.chmod(new File(path), mode);
    }

    public static void chmod(Path path, String perms) throws IOException {
        Assert.isNull((Object)path, (String)"File path cloud not be null.");
        Assert.isBlank((String)perms, (String)"File permission not be empty or null.");
        Set<PosixFilePermission> filePermissions = PosixFilePermissions.fromString(perms);
        java.nio.file.Files.setPosixFilePermissions(path, filePermissions);
    }

    public static void chmod(File file, String perms) throws IOException {
        Assert.isNull((Object)file, (String)"File cloud not be null.");
        Files.chmod(file.toPath(), perms);
    }

    public static void chmod(String path, String perms) throws IOException {
        Assert.isBlank((String)path, (String)"File path must be contain entity string.");
        Files.chmod(new File(path), perms);
    }

    public static String mode2perms(int mode) {
        char[] perms = new char[]{Files.getFilePerm(mode, 256, FilePermission.READ), Files.getFilePerm(mode, 128, FilePermission.WRITE), (mode & 0x40) != 0 ? Files.getFilePerm(mode, 2048, FilePermission.SGUID, FilePermission.EXECUTE) : ((mode & 0x800) != 0 ? 83 : (int)FilePermission.NONE.getValue()), Files.getFilePerm(mode, 32, FilePermission.READ), Files.getFilePerm(mode, 16, FilePermission.WRITE), (mode & 8) != 0 ? Files.getFilePerm(mode, 1024, FilePermission.SGUID, FilePermission.EXECUTE) : ((mode & 0x400) != 0 ? 83 : (int)FilePermission.NONE.getValue()), Files.getFilePerm(mode, 4, FilePermission.READ), Files.getFilePerm(mode, 2, FilePermission.WRITE), (mode & 1) != 0 ? Files.getFilePerm(mode, 512, FilePermission.STICKY, FilePermission.EXECUTE) : ((mode & 0x200) != 0 ? 84 : (int)FilePermission.NONE.getValue())};
        return new String(perms);
    }

    private static char getFilePerm(int mode, int factor, FilePermission defaultValue) {
        return Files.getFilePerm(mode, factor, defaultValue, FilePermission.NONE);
    }

    private static char getFilePerm(int mode, int factor, FilePermission t, FilePermission f) {
        return (mode & factor) != 0 ? t.getValue() : f.getValue();
    }
}

