/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io.json.deserializer;

import com.buession.io.MimeType;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public class MimeTypeStringDeserializer
extends StdScalarDeserializer<MimeType>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2065725897002881112L;

    public MimeTypeStringDeserializer() {
        super(MimeType.class);
    }

    public MimeTypeStringDeserializer(Class<? extends MimeType> clazz) {
        super(clazz);
    }

    public MimeType deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JacksonException {
        Object currentValue = jsonParser.getCurrentValue();
        Class<String> clazz = currentValue.getClass();
        if (clazz.isAssignableFrom(String.class)) {
            try {
                return MimeType.parse(currentValue.toString());
            }
            catch (Exception e) {
                throw new JsonParseException(jsonParser, e.getMessage(), jsonParser.getCurrentLocation(), (Throwable)e);
            }
        }
        throw new JsonParseException(jsonParser, clazz.getName() + " cloud not deserialize to: " + MimeType.class.getName(), jsonParser.getCurrentLocation());
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        return new MimeTypeStringDeserializer(property.getType().getRawClass());
    }
}

