/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io.json.serializer;

import com.buession.io.MimeType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;

public class MimeTypeStringSerializer
extends StdScalarSerializer<MimeType>
implements ContextualSerializer {
    private static final long serialVersionUID = 6096763941152821826L;

    public MimeTypeStringSerializer() {
        super(MimeType.class, false);
    }

    public MimeTypeStringSerializer(Class<? extends MimeType> clazz) {
        super(clazz, false);
    }

    public void serialize(MimeType value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        if (value == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(value.toString());
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(provider, property, this.handledType());
        if (format != null) {
            return new MimeTypeStringSerializer(property.getType().getRawClass());
        }
        return this;
    }
}

