/*
 * Decompiled with CFR 0.152.
 */
package com.buession.json.deserializer;

import com.buession.core.utils.EnumUtils;
import com.buession.core.utils.FieldUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonStdImpl
public class Map2EnumDeserializer
extends StdScalarDeserializer<Enum<?>>
implements ContextualDeserializer {
    private static final Map<String, Enum<?>> cache = new ConcurrentHashMap(32);
    private static final Logger logger = LoggerFactory.getLogger(Map2EnumDeserializer.class);

    public Map2EnumDeserializer() {
        super(Enum.class);
    }

    public Map2EnumDeserializer(Class<Enum<?>> v) {
        super(v);
    }

    public Enum<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String fieldName = jsonParser.getCurrentName();
        Object currentValue = jsonParser.getCurrentValue();
        Class<?> clazz = currentValue.getClass();
        try {
            Field[] nodeCurrentFieldTypeFields;
            Field nodeCurrentField = clazz.getDeclaredField(fieldName);
            Class<?> nodeCurrentFieldType = nodeCurrentField.getType();
            if (!nodeCurrentFieldType.isEnum()) {
                throw new JsonParseException(jsonParser, nodeCurrentFieldType.getName() + " is not Enum.");
            }
            if (node.size() == 0) {
                return Enum.valueOf(nodeCurrentFieldType, node.asText());
            }
            String cacheKey = Map2EnumDeserializer.parseCacheKey(clazz, nodeCurrentField, node);
            Enum<?> ret = cache.get(cacheKey);
            if (ret != null) {
                return ret;
            }
            Map<String, JsonNode> nodeMapValues = Map2EnumDeserializer.getNodeMapValues(node);
            for (Field field : nodeCurrentFieldTypeFields = nodeCurrentFieldType.getDeclaredFields()) {
                if (!field.isEnumConstant()) continue;
                FieldUtils.setAccessible((Field)field);
                Enum enumValue = (Enum)field.get(currentValue);
                if (enumValue == null) continue;
                Field[] enumValueFields = enumValue.getClass().getDeclaredFields();
                HashMap<String, Object> temp = new HashMap<String, Object>(enumValueFields.length);
                for (Field enumValueField : enumValueFields) {
                    if (!EnumUtils.notEnumValuesField((Field)enumValueField)) continue;
                    FieldUtils.setAccessible((Field)enumValueField);
                    temp.put(enumValueField.getName(), enumValueField.get(enumValue));
                }
                if (temp.size() != nodeMapValues.size() || !Map2EnumDeserializer.comparatorMap(temp, nodeMapValues)) continue;
                cache.put(cacheKey, enumValue);
                return enumValue;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        return new Map2EnumDeserializer(property.getType().getRawClass());
    }

    private static String parseCacheKey(Class<?> clazz, Field field, JsonNode node) {
        String className = clazz.getName();
        String fieldName = field.getName();
        String nodeName = node.toString();
        StringBuilder sb = new StringBuilder(className.length() + fieldName.length() + nodeName.length() + 2);
        sb.append(className).append('_').append(fieldName).append('_').append(nodeName);
        return sb.toString();
    }

    private static Map<String, JsonNode> getNodeMapValues(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        Iterator iterator = node.fields();
        HashMap<String, JsonNode> result = new HashMap<String, JsonNode>(node.size());
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            result.put((String)entry.getKey(), (JsonNode)entry.getValue());
        }
        return result;
    }

    private static boolean comparatorMap(Map<String, Object> map1, Map<String, JsonNode> map2) {
        for (Map.Entry<String, Object> entry : map1.entrySet()) {
            if (Map2EnumDeserializer.checkEquals(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEquals(Object value, JsonNode node) {
        if (node.isBigDecimal()) {
            return value.equals(node.decimalValue());
        }
        if (node.isBigInteger()) {
            return value.equals(node.shortValue()) || value.equals(node.intValue()) || value.equals(node.longValue()) || value.equals(node.bigIntegerValue());
        }
        if (node.isLong()) {
            return value.equals(node.shortValue()) || value.equals(node.intValue()) || value.equals(node.longValue()) || value.equals(node.bigIntegerValue());
        }
        if (node.isInt()) {
            return value.equals(node.shortValue()) || value.equals(node.intValue()) || value.equals(node.longValue()) || value.equals(node.bigIntegerValue());
        }
        if (node.isShort()) {
            return value.equals(node.shortValue()) || value.equals(node.intValue()) || value.equals(node.longValue()) || value.equals(node.bigIntegerValue());
        }
        if (node.isDouble()) {
            return value.equals(Float.valueOf(node.floatValue())) || value.equals(node.doubleValue());
        }
        if (node.isFloat()) {
            return value.equals(Float.valueOf(node.floatValue())) || value.equals(node.doubleValue());
        }
        if (node.isNumber()) {
            return value.equals(node.numberValue());
        }
        if (node.isBoolean() && value instanceof Boolean) {
            return value.equals(node.booleanValue());
        }
        if (node.isTextual() && value instanceof CharSequence) {
            return value.equals(node.textValue());
        }
        return false;
    }
}

