/*
 * Decompiled with CFR 0.152.
 */
package com.buession.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateSerializers
extends DateTimeSerializerBase<Date> {
    protected DateSerializers(Class<Date> type, Boolean useTimestamp, DateFormat customFormat) {
        super(type, useTimestamp, customFormat);
    }

    @JacksonStdImpl
    public static class TimestampUnixTimestampSerializer
    extends DateTimeSerializerBase<Timestamp> {
        public TimestampUnixTimestampSerializer() {
            this(null, null);
        }

        public TimestampUnixTimestampSerializer(Boolean useTimestamp, DateFormat customFormat) {
            super(Timestamp.class, useTimestamp, customFormat);
        }

        public TimestampUnixTimestampSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
            return new TimestampUnixTimestampSerializer(timestamp, customFormat);
        }

        public void serialize(Timestamp value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (this._asTimestamp(provider)) {
                generator.writeNumber(this._timestamp(value));
                return;
            }
            this._serializeAsString(new Date(value.getTime()), generator, provider);
        }

        protected long _timestamp(Timestamp value) {
            return value == null ? 0L : value.getTime() / 1000L;
        }
    }

    @JacksonStdImpl
    public static class CalendarUnixTimestampSerializer
    extends CalendarSerializer {
        public CalendarUnixTimestampSerializer() {
        }

        public CalendarUnixTimestampSerializer(Boolean useTimestamp, DateFormat customFormat) {
            super(useTimestamp, customFormat);
        }

        public CalendarUnixTimestampSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
            return new CalendarUnixTimestampSerializer(timestamp, customFormat);
        }

        protected long _timestamp(Calendar value) {
            return value == null ? 0L : value.getTimeInMillis() / 1000L;
        }
    }

    @JacksonStdImpl
    public static class SqlDateUnixTimestampSerializer
    extends SqlDateSerializer {
        public SqlDateUnixTimestampSerializer() {
        }

        public SqlDateUnixTimestampSerializer(Boolean useTimestamp, DateFormat customFormat) {
            super(useTimestamp, customFormat);
        }

        public SqlDateUnixTimestampSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
            return new SqlDateUnixTimestampSerializer(timestamp, customFormat);
        }

        protected long _timestamp(java.sql.Date value) {
            return value == null ? 0L : value.getTime() / 1000L;
        }
    }

    @JacksonStdImpl
    public static class DateUnixTimestampSerializer
    extends DateSerializer {
        public DateUnixTimestampSerializer() {
        }

        public DateUnixTimestampSerializer(Boolean useTimestamp, DateFormat customFormat) {
            super(useTimestamp, customFormat);
        }

        public DateUnixTimestampSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
            return new DateUnixTimestampSerializer(timestamp, customFormat);
        }

        protected long _timestamp(Date value) {
            return value == null ? 0L : value.getTime() / 1000L;
        }
    }
}

