/*
 * Decompiled with CFR 0.152.
 */
package com.buession.json.serializer;

import com.buession.core.utils.EnumUtils;
import com.buession.core.utils.FieldUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonStdImpl
public class Enum2MapSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 8436605332881634259L;
    private static final Logger logger = LoggerFactory.getLogger(Enum2MapSerializer.class);

    public Enum2MapSerializer() {
        super(Enum.class, false);
    }

    public Enum2MapSerializer(Class<Enum<?>> v) {
        super(v, false);
    }

    public void serialize(Enum en, JsonGenerator generator, SerializerProvider provider) throws IOException {
        Field[] fields = en.getClass().getDeclaredFields();
        generator.writeStartObject();
        for (Field field : fields) {
            if (field.isEnumConstant() || EnumUtils.isEnumValuesField((Field)field)) continue;
            Enum2MapSerializer.writeFieldValue(generator, en, field);
        }
        generator.writeEndObject();
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(provider, property, this.handledType());
        if (format != null) {
            return new Enum2MapSerializer(property.getType().getRawClass());
        }
        return this;
    }

    private static void writeFieldValue(JsonGenerator generator, Enum<?> en, Field field) throws IOException {
        FieldUtils.setAccessible((Field)field);
        try {
            generator.writeFieldName(field.getName());
            generator.writeObject(field.get(en));
        }
        catch (IllegalAccessException e) {
            logger.error("Read {}::{} failure: {}", new Object[]{field.getDeclaringClass().getName(), field.getName(), e.getMessage()});
        }
    }
}

