/*
 * Decompiled with CFR 0.152.
 */
package com.buession.json.serializer;

import com.buession.core.utils.ClassUtils;
import com.buession.core.validator.Validate;
import com.buession.json.annotation.Sensitive;
import com.buession.json.strategy.ISensitiveStrategy;
import com.buession.json.strategy.NoneSensitiveStrategy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@JacksonStdImpl
public class SensitiveSerializer
extends StdScalarSerializer<CharSequence>
implements ContextualSerializer {
    private static final long serialVersionUID = 5197972718452230362L;
    private ISensitiveStrategy strategy;
    private String format;
    private String replacement;
    private static final Map<String, ISensitiveStrategy> SENSITIVE_STRATEGY_CACHE = new ConcurrentHashMap<String, ISensitiveStrategy>(8);

    public SensitiveSerializer() {
        super(CharSequence.class);
    }

    public void serialize(CharSequence value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (value == null) {
            jsonGenerator.writeNull();
        } else if (value.length() == 0) {
            jsonGenerator.writeString("");
        } else {
            String str = Validate.hasText((CharSequence)this.format) ? value.toString().replaceAll(this.format, Optional.ofNullable(this.replacement).orElse("***")) : this.strategy.getFunction().apply(value.toString());
            jsonGenerator.writeString(str);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Sensitive annotation = (Sensitive)property.getAnnotation(Sensitive.class);
        if (Objects.nonNull(annotation) && CharSequence.class.isAssignableFrom(property.getType().getRawClass())) {
            this.format = annotation.format();
            this.replacement = annotation.replacement();
            if (Validate.isEmpty((CharSequence)this.format)) {
                this.strategy = annotation.strategyType() != NoneSensitiveStrategy.class ? SENSITIVE_STRATEGY_CACHE.computeIfAbsent(annotation.strategyType().getName() + '@' + this.replacement, key -> (ISensitiveStrategy)ClassUtils.instantiate(annotation.strategyType(), (Object[])new Object[]{this.replacement})) : SENSITIVE_STRATEGY_CACHE.computeIfAbsent(annotation.strategy().getStrategy().getName() + '@' + this.replacement, key -> (ISensitiveStrategy)ClassUtils.instantiate(annotation.strategy().getStrategy(), (Object[])new Object[]{this.replacement}));
            }
            return this;
        }
        return provider.findValueSerializer(property.getType(), property);
    }
}

