/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.aop.aspect;

import com.buession.aop.aspectj.AbstractAspectjAnnotationsMethodInterceptor;
import com.buession.core.utils.Assert;
import com.buession.web.aop.aspect.WebAnnotationAspect;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebAnnotationAspect<T extends AbstractAspectjAnnotationsMethodInterceptor>
implements WebAnnotationAspect {
    protected final T methodInterceptor;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractWebAnnotationAspect(T methodInterceptor) {
        Assert.isNull(methodInterceptor, (String)("The instance for " + this.getClass().getName() + " cloud not be null."));
        this.methodInterceptor = methodInterceptor;
    }

    @Override
    public void anyAnnotatedMethod() {
        this.annotatedMethodExecuteLog("anyAnnotatedMethod");
    }

    @Override
    public void anyAnnotatedMethodCall(JoinPoint joinPoint) {
        this.annotatedMethodExecuteLog("anyAnnotatedMethodCall");
    }

    protected void annotatedMethodExecuteLog(String method) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Call {}::{}()", (Object)this.getClass().getName(), (Object)method);
        }
    }
}

