/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.bind.converter;

import com.buession.core.utils.Assert;
import com.buession.core.utils.EnumUtils;
import com.buession.core.validator.Validate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.lang.Nullable;

public class IgnoreCaseEnumConverterFactory
implements ConverterFactory<String, Enum> {
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnum(IgnoreCaseEnumConverterFactory.getEnumType(targetType));
    }

    private static Class<?> getEnumType(Class<?> targetType) {
        Class<?> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.isNull(enumType, (String)("The target type " + targetType.getName() + " does not refer to an enum"));
        return enumType;
    }

    private static class StringToEnum<T extends Enum<T>>
    implements Converter<String, T> {
        private final Class<T> enumType;

        public StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Nullable
        public T convert(String source) {
            if (Validate.isEmpty((CharSequence)source)) {
                return null;
            }
            return (T)EnumUtils.getEnumIgnoreCase(this.enumType, (String)source.trim());
        }
    }
}

