/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.http.request;

import com.buession.core.validator.Validate;
import com.buession.web.http.HttpHeader;
import java.util.function.Function;

public abstract class RequestUtils {
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final String[] CLIENT_IP_HEADERS = new String[]{"X-Forwarded-For-Pound", "Ali-Cdn-Real-Ip", "Cdn-Src-Ip", "X-Cdn-Src-Ip", "X-Original-Forwarded-For", "X-Forwarded-For", "X-Real-Ip", "Proxy-Client-IP", "WL-Proxy-Client-IP", "Real-ClientIP", "Client-IP"};
    public static final String[] MOBILE_MAPS = new String[]{"android", "iphone", "ipod", "windows phone", "windowsce", "mobile", "coolpad", "mmp", "smartphone", "midp", "wap", "xoom", "symbian", "j2me", "ucweb", "operamini", "operamobi", "MicroMessenger", "MQQBrowser", "wince", "Nokia", "SonyEricsson", "Sony", "Ericsson", "Mot", "Samsung", "HTC", "sgh", "LG", "sharp", "sie-", "Philips", "Haier", "Changhong", "Panasonic", "alcatel", "Lenovo", "blackberry", "meizu", "netfront", "palm", "openwave", "nexusone", "cldc", "midp", "Huawei", "TCL", "CECT", "Compal", "NEC", "TDG", "Alcatel", "BIRD", "DAXIAN", "DBTEL", "Eastcom", "PANTECH", "Dopod", "KONKA", "Kejian", "BenQ", "Soutec", "SAGEM", "SIE", "Amoi", "ZTE", "Xiaomi"};

    protected static <T> T iteratorRequestHeader(Function<String, T> function, Function<T, Boolean> validator, String ... headerNames) {
        for (String headerName : headerNames) {
            T result = function.apply(headerName);
            if (!validator.apply(result).booleanValue()) continue;
            return result;
        }
        return null;
    }

    protected static String getScheme(Function<String, String> function) {
        return RequestUtils.iteratorRequestHeader(function, Validate::hasText, HttpHeader.X_FORWARDED_PROTOCOL.getValue(), HttpHeader.X_FORWARDED_PROTO.getValue());
    }

    protected static String getHost(Function<String, String> function) {
        return RequestUtils.iteratorRequestHeader(function, Validate::hasText, HttpHeader.X_FORWARDED_HOST.getValue(), HttpHeader.HOST.getValue());
    }

    protected static String getClientIp(Function<String, String> function, String remoteAddr) {
        String ip = RequestUtils.iteratorRequestHeader(function, value -> Validate.hasText((CharSequence)value) && !"unknown".equalsIgnoreCase((String)value), CLIENT_IP_HEADERS);
        if (ip != null) {
            return ip;
        }
        ip = remoteAddr;
        if (Validate.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = DEFAULT_IP;
        }
        return ip;
    }

    protected static boolean isAjaxRequest(String xRequestedWith) {
        return "XMLHttpRequest".equalsIgnoreCase(xRequestedWith);
    }

    protected static boolean isMobile(String userAgent, String accept) {
        if (Validate.isBlank((CharSequence)userAgent)) {
            return false;
        }
        String userAgentLower = userAgent.toLowerCase();
        for (String s : MOBILE_MAPS) {
            if (!userAgentLower.contains(s.toLowerCase())) continue;
            return true;
        }
        if (Validate.isBlank((CharSequence)accept)) {
            return false;
        }
        String wml = "vnd.wap.wml";
        String html = "text/html";
        return accept.contains("vnd.wap.wml") && !accept.contains("text/html") || accept.indexOf("vnd.wap.wml") > accept.indexOf("text/html");
    }

    protected static String getAuthority(String scheme, String host, int port) {
        if (port == 0) {
            return host;
        }
        StringBuilder sb = new StringBuilder(host);
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            sb.append(':').append(port);
        }
        return sb.toString();
    }
}

