/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.http.request.annotation;

import com.buession.net.utils.InetAddressUtils;
import com.buession.web.http.request.annotation.RequestClientIp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;

public class RequestClientIpAnnotationUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestClientIpAnnotationUtils.class);

    private RequestClientIpAnnotationUtils() {
    }

    public static boolean checkSupports(MethodParameter parameter) {
        if (!parameter.hasParameterAnnotation(RequestClientIp.class)) {
            return false;
        }
        Class clazz = parameter.nestedIfOptional().getNestedParameterType();
        return CharSequence.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || InetAddress.class.isAssignableFrom(clazz);
    }

    @Nullable
    public static Object resolveNamedValue(MethodParameter parameter, Function<MethodParameter, String> fn) {
        Class clazz = parameter.nestedIfOptional().getNestedParameterType();
        if (Long.class.isAssignableFrom(clazz)) {
            return InetAddressUtils.ip2long((String)fn.apply(parameter));
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return fn.apply(parameter);
        }
        if (InetAddress.class.isAssignableFrom(clazz)) {
            String ip = fn.apply(parameter);
            try {
                return InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                logger.error("IP: <{}> convert to InetAddress error: {}", (Object)ip, (Object)e.getMessage());
            }
        }
        return null;
    }
}

