/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.annotation;

import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import com.buession.web.http.request.annotation.RequestClientIp;
import com.buession.web.http.request.annotation.RequestClientIpAnnotationUtils;
import com.buession.web.reactive.http.request.RequestUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class RequestClientIpHandlerMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public RequestClientIpHandlerMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return RequestClientIpAnnotationUtils.checkSupports(parameter);
    }

    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestClientIp requestClientIp = (RequestClientIp)parameter.getParameterAnnotation(RequestClientIp.class);
        Assert.isNull((Object)requestClientIp, (String)"No RequestClientIp annotation");
        return new RequestClientIpNamedValueInfo(requestClientIp);
    }

    @Nullable
    protected Object resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        return RequestClientIpAnnotationUtils.resolveNamedValue(parameter, methodParameter -> this.getClientIp(exchange.getRequest(), (MethodParameter)methodParameter));
    }

    @Nullable
    private String getClientIp(ServerHttpRequest request, MethodParameter parameter) {
        RequestClientIp requestClientIp = (RequestClientIp)parameter.getParameterAnnotation(RequestClientIp.class);
        if (requestClientIp != null && Validate.isNotEmpty((Object[])requestClientIp.headerName())) {
            HttpHeaders httpHeaders = request.getHeaders();
            for (String headerName : requestClientIp.headerName()) {
                String clientIp;
                if (!Validate.hasText((CharSequence)headerName) || "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(headerName) || !Validate.hasText((CharSequence)(clientIp = httpHeaders.getFirst(headerName)))) continue;
                return clientIp;
            }
        }
        return RequestUtils.getClientIp(request);
    }

    private static final class RequestClientIpNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private RequestClientIpNamedValueInfo(RequestClientIp annotation) {
            super(RequestClientIp.class.getName(), true, null);
        }
    }
}

