/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.web.aop.handler.AbstractContentTypeAnnotationHandler;
import com.buession.web.http.response.annotation.ContentType;
import com.buession.web.reactive.http.request.RequestUtils;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringValueResolver;

public class ReactiveContentTypeAnnotationHandler
extends AbstractContentTypeAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReactiveContentTypeAnnotationHandler.class);

    @Deprecated
    public ReactiveContentTypeAnnotationHandler() {
    }

    public ReactiveContentTypeAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, ContentType contentType) {
        ServerHttpResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("ServerHttpResponse is null");
            return;
        }
        String mime = this.stringValueResolver == null ? contentType.mime() : this.stringValueResolver.resolveStringValue(contentType.mime());
        int i = mime.indexOf(47);
        Charset charset = Charset.forName(this.stringValueResolver == null ? contentType.charset() : this.stringValueResolver.resolveStringValue(contentType.charset()));
        String type = mime.substring(0, i - 1);
        String subType = mime.substring(i);
        response.getHeaders().setContentType(new MediaType(type, subType, charset));
    }
}

