/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractHttpCacheAnnotationHandler;
import com.buession.web.http.response.annotation.HttpCache;
import com.buession.web.reactive.http.request.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringValueResolver;

public class ReactiveHttpCacheAnnotationHandler
extends AbstractHttpCacheAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReactiveHttpCacheAnnotationHandler.class);

    @Deprecated
    public ReactiveHttpCacheAnnotationHandler() {
    }

    public ReactiveHttpCacheAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, HttpCache httpCache) {
        ServerHttpResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("ServerHttpResponse is null");
            return;
        }
        HttpHeaders httpHeaders = response.getHeaders();
        boolean isSetCacheControl = false;
        if (Validate.hasText((CharSequence)httpCache.cacheControl())) {
            if (this.stringValueResolver == null) {
                httpHeaders.setCacheControl(httpCache.cacheControl());
            } else {
                httpHeaders.setCacheControl(this.stringValueResolver.resolveStringValue(httpCache.cacheControl()));
            }
            isSetCacheControl = true;
        }
        if (Validate.hasText((CharSequence)httpCache.expires())) {
            String expires;
            String string = expires = this.stringValueResolver == null ? httpCache.expires() : this.stringValueResolver.resolveStringValue(httpCache.expires());
            if (Validate.isNumeric((CharSequence)expires)) {
                httpHeaders.setExpires(Long.parseLong(expires));
                if (!isSetCacheControl) {
                    httpHeaders.setCacheControl("max-age=" + expires);
                }
            }
        }
        if (Validate.hasText((CharSequence)httpCache.pragma())) {
            if (this.stringValueResolver == null) {
                httpHeaders.setPragma(httpCache.pragma());
            } else {
                httpHeaders.setPragma(this.stringValueResolver.resolveStringValue(httpCache.pragma()));
            }
        }
    }
}

