/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractResponseHeaderAnnotationHandler;
import com.buession.web.http.HttpHeader;
import com.buession.web.http.response.annotation.ResponseHeader;
import com.buession.web.reactive.http.request.RequestUtils;
import com.buession.web.reactive.http.response.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringValueResolver;

public class ReactiveResponseHeaderAnnotationHandler
extends AbstractResponseHeaderAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReactiveResponseHeaderAnnotationHandler.class);

    @Deprecated
    public ReactiveResponseHeaderAnnotationHandler() {
    }

    public ReactiveResponseHeaderAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, ResponseHeader responseHeader) {
        ServerHttpResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("ServerHttpResponse is null");
            return;
        }
        boolean isExpires = HttpHeader.EXPIRES.getValue().equalsIgnoreCase(responseHeader.name());
        for (String value : responseHeader.value()) {
            if (this.stringValueResolver != null) {
                value = this.stringValueResolver.resolveStringValue(value);
            }
            if (isExpires) {
                if (Validate.isNumeric((CharSequence)value)) {
                    ResponseUtils.httpCache(response, Integer.parseInt(value));
                    continue;
                }
                ResponseUtils.httpCache(response, value);
                continue;
            }
            response.getHeaders().set(responseHeader.name(), value);
        }
    }
}

