/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractResponseHeadersAnnotationHandler;
import com.buession.web.http.HttpHeader;
import com.buession.web.http.response.annotation.ResponseHeaders;
import com.buession.web.reactive.http.request.RequestUtils;
import com.buession.web.reactive.http.response.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringValueResolver;

public class ReactiveResponseHeadersAnnotationHandler
extends AbstractResponseHeadersAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReactiveResponseHeadersAnnotationHandler.class);

    @Deprecated
    public ReactiveResponseHeadersAnnotationHandler() {
    }

    public ReactiveResponseHeadersAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, ResponseHeaders responseHeaders) {
        ServerHttpResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("ServerHttpResponse is null");
            return;
        }
        Object[] headers = responseHeaders.value();
        if (Validate.isNotEmpty((Object[])headers)) {
            HttpHeaders httpHeaders = response.getHeaders();
            for (Object header : headers) {
                boolean isExpires = HttpHeader.EXPIRES.getValue().equalsIgnoreCase(header.name());
                for (String value : header.value()) {
                    if (this.stringValueResolver != null) {
                        value = this.stringValueResolver.resolveStringValue(value);
                    }
                    if (isExpires) {
                        if (Validate.isNumeric((CharSequence)value)) {
                            ResponseUtils.httpCache(response, Integer.parseInt(value));
                            continue;
                        }
                        ResponseUtils.httpCache(response, value);
                        continue;
                    }
                    httpHeaders.set(header.name(), value);
                }
            }
        }
    }
}

