/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.config;

import com.buession.web.bind.converter.FormatterRegistryUtils;
import com.buession.web.reactive.OnWebFluxCondition;
import com.buession.web.reactive.annotation.RequestClientIpHandlerMethodArgumentResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

@Configuration(proxyBeanMethods=false)
@Conditional(value={OnWebFluxCondition.class})
public class WebFluxConfiguration
implements WebFluxConfigurer {
    private final ConfigurableBeanFactory factory;
    private final ReactiveAdapterRegistry registry;

    public WebFluxConfiguration(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        this.factory = factory;
        this.registry = registry;
    }

    public void addFormatters(@NonNull FormatterRegistry registry) {
        FormatterRegistryUtils.addConverters(registry);
    }

    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{new RequestClientIpHandlerMethodArgumentResolver(this.factory, this.registry)});
    }
}

