/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.context.request;

import com.buession.core.utils.Assert;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;

public class ReactiveRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = ReactiveRequestAttributes.class.getName() + ".DESTRUCTION_CALLBACK.";
    protected static final Set<Class<?>> immutableValueTypes = new HashSet(16);
    private final ServerWebExchange exchange;
    private final ServerHttpRequest request;
    private final ServerHttpResponse response;
    @Nullable
    private volatile WebSession session;

    public ReactiveRequestAttributes(ServerWebExchange exchange) {
        Assert.isNull((Object)exchange, (String)"ServerWebExchange must not be null");
        this.exchange = exchange;
        this.request = exchange.getRequest();
        this.response = exchange.getResponse();
    }

    public final ServerHttpRequest getRequest() {
        return this.request;
    }

    @Nullable
    public final ServerHttpResponse getResponse() {
        return this.response;
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attribute - request is not active anymore!");
            }
            return this.exchange.getAttribute(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot set request attribute - request is not active anymore!");
            }
            this.exchange.getAttributes().put(name, value);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0 && this.isRequestActive()) {
            this.removeRequestDestructionCallback(name);
            this.exchange.getAttributes().remove(name);
        }
    }

    public String[] getAttributeNames(int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attributes - request is not active anymore!");
            }
            return this.exchange.getAttributes().keySet().toArray(new String[0]);
        }
        return new String[0];
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
    }

    public Object resolveReference(String key) {
        if ("request".equals(key)) {
            return this.request;
        }
        if ("session".equals(key)) {
            return null;
        }
        return null;
    }

    public String getSessionId() {
        throw new IllegalStateException("Cloud not invoke in webflux");
    }

    public Object getSessionMutex() {
        throw new IllegalStateException("Cloud not invoke in webflux");
    }

    protected void updateAccessedSessionAttributes() {
    }

    public String toString() {
        return this.request.toString();
    }

    static {
        immutableValueTypes.addAll(NumberUtils.STANDARD_NUMBER_TYPES);
        immutableValueTypes.add(Boolean.class);
        immutableValueTypes.add(Character.class);
        immutableValueTypes.add(String.class);
    }
}

