/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.filter;

import com.buession.core.validator.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class PrintUrlFilter
implements WebFilter {
    private static final Logger logger = LoggerFactory.getLogger(PrintUrlFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String url;
        ServerHttpRequest request = exchange.getRequest();
        if (logger.isInfoEnabled() && Validate.hasText((CharSequence)(url = this.parseUrl(request)))) {
            logger.info("Request URL: {}", (Object)url);
        }
        return chain.filter(exchange);
    }

    protected String parseUrl(ServerHttpRequest request) {
        return request.getURI().toString();
    }
}

