/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.filter;

import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ResponseHeaderFilter
implements WebFilter {
    private String name;
    private String value;

    public ResponseHeaderFilter() {
    }

    public ResponseHeaderFilter(String name, String value) {
        this.setName(name);
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.isBlank((String)name, (String)"HTTP Response header name cloud not be empty or null");
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (Validate.hasText((CharSequence)this.getName())) {
            exchange.getResponse().getHeaders().set(this.getName(), this.getValue());
        }
        return chain.filter(exchange);
    }
}

