/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.filter;

import com.buession.core.validator.Validate;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ResponseHeadersFilter
implements WebFilter {
    private Map<String, String> headers;

    public ResponseHeadersFilter() {
    }

    public ResponseHeadersFilter(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Map<String, String> headers = this.getHeaders();
        if (Validate.isNotEmpty(headers)) {
            HttpHeaders httpHeaders = exchange.getResponse().getHeaders();
            httpHeaders.setAll(headers);
        }
        return chain.filter(exchange);
    }
}

