/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.filter;

import com.buession.core.builder.MapBuilder;
import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import com.buession.web.http.response.IServerInfoFilter;
import com.buession.web.reactive.filter.ResponseHeadersFilter;
import com.buession.web.utils.ServerUtils;
import java.util.Map;

public class ServerInfoFilter
extends ResponseHeadersFilter
implements IServerInfoFilter {
    private String headerName;

    public ServerInfoFilter() {
        this("Server-Name");
    }

    public ServerInfoFilter(String headerName) {
        this.setHeaderName(headerName);
    }

    @Override
    public String getHeaderName() {
        return this.headerName;
    }

    @Override
    public void setHeaderName(String headerName) {
        Assert.isBlank((String)headerName, (String)"Server info response header name cloud not be null or empty");
        this.headerName = headerName;
    }

    @Override
    public Map<String, String> getHeaders() {
        Map<String, String> headers = super.getHeaders();
        if (Validate.isEmpty(headers)) {
            this.setHeaders(MapBuilder.of((Object)this.getHeaderName(), (Object)this.format(ServerUtils.getHostName())));
        }
        return headers;
    }

    protected String format(String computerName) {
        return computerName;
    }
}

