/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.http.request;

import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import com.buession.web.http.HttpHeader;
import com.buession.web.reactive.context.request.ReactiveRequestAttributes;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestUtils
extends com.buession.web.http.request.RequestUtils {
    private RequestUtils() {
    }

    public static ServerHttpResponse getResponse() {
        ReactiveRequestAttributes requestAttributes = (ReactiveRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes.getResponse();
    }

    public static String getClientIp(ServerHttpRequest request) {
        Assert.isNull((Object)request, (String)"HttpServletRequest cloud not be null.");
        HttpHeaders httpHeaders = request.getHeaders();
        return RequestUtils.getClientIp(headerName -> {
            List values = httpHeaders.get(headerName);
            if (values != null) {
                for (String ip : values) {
                    if (!Validate.hasText((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) continue;
                    return ip;
                }
            }
            return null;
        }, request.getRemoteAddress() == null ? null : request.getRemoteAddress().getAddress().getHostAddress());
    }

    public static boolean isAjaxRequest(ServerHttpRequest request) {
        HttpHeaders httpHeaders = request.getHeaders();
        return RequestUtils.isAjaxRequest(httpHeaders.getFirst(HttpHeader.X_REQUESTED_WITH.getValue()));
    }

    public static boolean isMobile(ServerHttpRequest request) {
        HttpHeaders httpHeaders = request.getHeaders();
        return RequestUtils.isMobile(httpHeaders.getFirst(HttpHeader.USER_AGENT.getValue()), httpHeaders.getFirst(HttpHeader.ACCEPT.getValue()));
    }

    public static String getScheme(ServerHttpRequest request) {
        HttpHeaders httpHeaders = request.getHeaders();
        String scheme = RequestUtils.getScheme(arg_0 -> ((HttpHeaders)httpHeaders).getFirst(arg_0));
        return Validate.hasText((CharSequence)scheme) ? scheme : request.getURI().getScheme();
    }

    public static String getHost(ServerHttpRequest request) {
        HttpHeaders httpHeaders = request.getHeaders();
        String host = RequestUtils.getScheme(arg_0 -> ((HttpHeaders)httpHeaders).getFirst(arg_0));
        return Validate.hasText((CharSequence)host) ? host : request.getURI().getHost();
    }

    @Deprecated
    public static String getDomain(ServerHttpRequest request) {
        return RequestUtils.getHost(request);
    }

    public static int getPort(ServerHttpRequest request) {
        HttpHeaders httpHeaders = request.getHeaders();
        String forwardedPort = httpHeaders.getFirst(HttpHeader.X_FORWARDED_PORT.getValue());
        return Validate.hasText((CharSequence)forwardedPort) ? Integer.parseInt(forwardedPort) : request.getURI().getPort();
    }

    public static String getAuthority(ServerHttpRequest request) {
        String host = RequestUtils.getHost(request);
        return RequestUtils.getAuthority(RequestUtils.getScheme(request), host, host.contains(":") ? 0 : RequestUtils.getPort(request));
    }
}

