/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.reactive.http.response;

import com.buession.core.utils.ObjectUtils;
import java.util.Date;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;

public class ResponseUtils {
    private ResponseUtils() {
    }

    public static void httpCache(ServerHttpResponse response, String value) {
        ObjectUtils.invokeIfAvailable((Object)response, res -> res.getHeaders().setCacheControl(value));
    }

    public static void httpCache(ServerHttpResponse response, int lifetime) {
        ObjectUtils.invokeIfAvailable((Object)response, res -> {
            long expiresAt = System.currentTimeMillis() + (long)lifetime * 1000L;
            ResponseUtils.httpCache(res, lifetime, expiresAt);
        });
    }

    public static void httpCache(ServerHttpResponse response, Date date) {
        ObjectUtils.invokeIfAvailable((Object)response, res -> {
            long maxAge = date.getTime() - System.currentTimeMillis();
            ResponseUtils.httpCache(res, maxAge, date.getTime());
        });
    }

    private static void httpCache(ServerHttpResponse response, long maxAge, long expires) {
        HttpHeaders httpHeaders = response.getHeaders();
        httpHeaders.setCacheControl(maxAge < 0L ? "no-cache" : "max-age=" + maxAge);
        httpHeaders.setExpires(expires);
        httpHeaders.setPragma(maxAge > 0L ? null : "no-cache");
    }
}

