/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet;

import com.buession.core.collect.Arrays;
import com.buession.web.servlet.ServletExceptionHandlerResolver;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.springframework.web.util.WebUtils;

public abstract class AbstractHandlerExceptionResolver
extends org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver
implements ServletExceptionHandlerResolver {
    private String exceptionAttribute = "exception";
    private String defaultErrorView = "error";
    private String cacheControl = "no-cache";
    private Map<HttpStatus, String> errorViews;
    private Map<Exception, String> exceptionViews;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final Logger pageNotFoundLogger = LoggerFactory.getLogger((String)"org.springframework.web.servlet.PageNotFound");

    public String getExceptionAttribute() {
        return this.exceptionAttribute;
    }

    public void setExceptionAttribute(String exceptionAttribute) {
        this.exceptionAttribute = exceptionAttribute;
    }

    public String getDefaultErrorView() {
        return this.defaultErrorView;
    }

    public void setDefaultErrorView(String defaultErrorView) {
        this.defaultErrorView = defaultErrorView;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public Map<HttpStatus, String> getErrorViews() {
        return this.errorViews;
    }

    public void setErrorViews(Map<HttpStatus, String> errorViews) {
        this.errorViews = errorViews;
    }

    public Map<Exception, String> getExceptionViews() {
        return this.exceptionViews;
    }

    public void setExceptionViews(Map<Exception, String> exceptionViews) {
        this.exceptionViews = exceptionViews;
    }

    @ExceptionHandler(value={Throwable.class, Exception.class})
    @Nullable
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        block19: {
            ModelAndView mv;
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Resolve Exception: {}", (Object)ex.getMessage(), (Object)ex);
            }
            if ((mv = this.doSpecialResolveException(request, response, handler, ex)) != null) {
                return mv;
            }
            try {
                if (ex instanceof MethodArgumentNotValidException) {
                    return this.handleMethodArgumentNotValidException(request, response, handler, (MethodArgumentNotValidException)ex);
                }
                if (ex instanceof MissingServletRequestPartException) {
                    return this.handleMissingServletRequestPartException(request, response, handler, (MissingServletRequestPartException)ex);
                }
                if (ex instanceof BindException) {
                    return this.handleBindException(request, response, handler, (BindException)ex);
                }
                if (ex instanceof TypeMismatchException) {
                    return this.handleTypeMismatchException(request, response, handler, (TypeMismatchException)ex);
                }
                if (ex instanceof HttpMessageNotReadableException) {
                    return this.handleHttpMessageNotReadableException(request, response, handler, (HttpMessageNotReadableException)ex);
                }
                if (ex instanceof MissingServletRequestParameterException) {
                    return this.handleMissingServletRequestParameterException(request, response, handler, (MissingServletRequestParameterException)ex);
                }
                if (ex instanceof ServletRequestBindingException) {
                    return this.handleServletRequestBindingException(request, response, handler, (ServletRequestBindingException)ex);
                }
                if (ex instanceof NoHandlerFoundException) {
                    return this.handleNoHandlerFoundException(request, response, handler, (NoHandlerFoundException)ex);
                }
                if (ex instanceof HttpRequestMethodNotSupportedException) {
                    return this.handleHttpRequestMethodNotSupportedException(request, response, handler, (HttpRequestMethodNotSupportedException)ex);
                }
                if (ex instanceof HttpMediaTypeNotAcceptableException) {
                    return this.handleHttpMediaTypeNotAcceptableException(request, response, handler, (HttpMediaTypeNotAcceptableException)ex);
                }
                if (ex instanceof HttpMediaTypeNotSupportedException) {
                    return this.handleHttpMediaTypeNotSupportedException(request, response, handler, (HttpMediaTypeNotSupportedException)ex);
                }
                if (ex instanceof MissingPathVariableException) {
                    return this.handleMissingPathVariableException(request, response, handler, (MissingPathVariableException)ex);
                }
                if (ex instanceof ConversionNotSupportedException) {
                    return this.handleConversionNotSupportedException(request, response, handler, (ConversionNotSupportedException)ex);
                }
                if (ex instanceof HttpMessageNotWritableException) {
                    return this.handleHttpMessageNotWritableException(request, response, handler, (HttpMessageNotWritableException)ex);
                }
                if (ex instanceof AsyncRequestTimeoutException) {
                    return this.handleAsyncRequestTimeoutException(request, response, handler, (AsyncRequestTimeoutException)ex);
                }
            }
            catch (Exception handlerEx) {
                if (!this.logger.isWarnEnabled()) break block19;
                this.logger.warn("Failure while trying to resolve exception [{}]", (Object)ex.getClass().getName(), (Object)handlerEx);
            }
        }
        return this.doDefaultResolveException(request, response, handler, ex);
    }

    protected ModelAndView doSpecialResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        return null;
    }

    protected ModelAndView doDefaultResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        return null;
    }

    protected ModelAndView handleMethodArgumentNotValidException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, MethodArgumentNotValidException ex) {
        response.setStatus(400);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleMissingServletRequestPartException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, MissingServletRequestPartException ex) {
        response.setStatus(400);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleBindException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, BindException ex) {
        response.setStatus(400);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleMissingServletRequestParameterException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, MissingServletRequestParameterException ex) {
        response.setStatus(400, ex.getMessage());
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleServletRequestBindingException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, ServletRequestBindingException ex) {
        response.setStatus(400, ex.getMessage());
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleTypeMismatchException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, TypeMismatchException ex) {
        response.setStatus(400);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleHttpMessageNotReadableException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, HttpMessageNotReadableException ex) {
        response.setStatus(400);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleNoHandlerFoundException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, NoHandlerFoundException ex) {
        pageNotFoundLogger.warn(ex.getMessage());
        response.setStatus(404);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleHttpRequestMethodNotSupportedException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, HttpRequestMethodNotSupportedException ex) {
        response.setStatus(405, ex.getMessage());
        Object[] supportedMethods = ex.getSupportedMethods();
        if (supportedMethods != null) {
            response.setHeader("Allow", Arrays.toString((Object[])supportedMethods, (String)", "));
        }
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleHttpMediaTypeNotAcceptableException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, HttpMediaTypeNotAcceptableException ex) {
        response.setStatus(406);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleHttpMediaTypeNotSupportedException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, HttpMediaTypeNotSupportedException ex) {
        response.setStatus(415);
        List mediaTypes = ex.getSupportedMediaTypes();
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            response.setHeader("Accept", MediaType.toString((Collection)mediaTypes));
        }
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleMissingPathVariableException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, MissingPathVariableException ex) {
        response.setStatus(500, ex.getMessage());
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleConversionNotSupportedException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, ConversionNotSupportedException ex) {
        response.setStatus(500);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleHttpMessageNotWritableException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, HttpMessageNotWritableException ex) {
        response.setStatus(500);
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected ModelAndView handleAsyncRequestTimeoutException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, AsyncRequestTimeoutException ex) {
        if (!response.isCommitted()) {
            response.setStatus(503);
        } else {
            this.logger.warn("Async request timed out");
        }
        return this.doResolve(request, response, handler, (Exception)ex);
    }

    protected boolean acceptTextHtml(HttpServletRequest request) {
        return true;
    }

    protected boolean acceptJson(HttpServletRequest request) {
        String contentType = request.getHeader("Content-Type");
        return contentType != null && contentType.contains("application/json");
    }

    protected ModelAndView createModelAndView(HttpServletRequest request, HttpServletResponse response, HttpStatus httpStatus, Exception ex) {
        return this.acceptJson(request) ? new ModelAndView((View)new MappingJackson2JsonView()) : new ModelAndView(this.determineViewName(request, response, ex, httpStatus));
    }

    @Deprecated
    protected ModelAndView doResolve(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        return this.doResolve(request, response, null, ex);
    }

    protected ModelAndView doResolve(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        request.setAttribute("javax.servlet.error.exception", (Object)ex);
        HttpStatus httpStatus = HttpStatus.resolve((int)response.getStatus());
        ModelAndView mv = this.createModelAndView(request, response, httpStatus, ex);
        mv.addObject("state", (Object)false);
        mv.addObject("code", (Object)response.getStatus());
        mv.addObject("message", (Object)httpStatus.getReasonPhrase());
        mv.addObject("status", (Object)httpStatus);
        mv.addObject("timestamp", (Object)new Date());
        mv.addObject(this.getExceptionAttribute(), (Object)ex);
        this.applyStatusCodeIfPossible(request, response, httpStatus);
        return mv;
    }

    protected String determineViewName(HttpServletRequest request, HttpServletResponse response, Exception ex, HttpStatus httpStatus) {
        String viewName = null;
        if (this.getExceptionViews() != null) {
            viewName = this.getExceptionViews().get(ex);
        }
        if (viewName == null && this.getErrorViews() != null) {
            viewName = this.getErrorViews().get(httpStatus);
        }
        if (viewName == null) {
            viewName = (String)SERIES_VIEWS.get(httpStatus.series());
        }
        if (viewName == null && this.getDefaultErrorView() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolving to default view '{}' for exception of type [{}]", (Object)this.getDefaultErrorView(), (Object)ex.getClass().getName());
            }
            viewName = this.getDefaultErrorView();
        }
        return viewName;
    }

    protected void applyStatusCodeIfPossible(HttpServletRequest request, HttpServletResponse response, HttpStatus statusCode) {
        if (!WebUtils.isIncludeRequest((ServletRequest)request)) {
            this.logger.debug("Applying HTTP status code {}", (Object)statusCode);
            if (this.getCacheControl() != null) {
                response.setHeader("Cache-Control", this.getCacheControl());
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)statusCode);
        }
    }
}

