/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.annotation;

import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import com.buession.web.http.request.annotation.RequestClientIp;
import com.buession.web.http.request.annotation.RequestClientIpAnnotationUtils;
import com.buession.web.servlet.http.request.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;

public class RequestClientIpHandlerMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public RequestClientIpHandlerMethodArgumentResolver() {
    }

    public RequestClientIpHandlerMethodArgumentResolver(@Nullable ConfigurableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return RequestClientIpAnnotationUtils.checkSupports(parameter);
    }

    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestClientIp requestClientIp = (RequestClientIp)parameter.getParameterAnnotation(RequestClientIp.class);
        Assert.isNull((Object)requestClientIp, (String)"No RequestClientIp annotation");
        return new RequestClientIpNamedValueInfo(requestClientIp);
    }

    @Nullable
    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) {
        return RequestClientIpAnnotationUtils.resolveNamedValue(parameter, methodParameter -> this.getClientIp(request, (MethodParameter)methodParameter));
    }

    @Nullable
    private String getClientIp(NativeWebRequest webRequest, MethodParameter parameter) {
        RequestClientIp requestClientIp = (RequestClientIp)parameter.getParameterAnnotation(RequestClientIp.class);
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (requestClientIp != null && request != null && Validate.isNotEmpty((Object[])requestClientIp.headerName())) {
            for (String headerName : requestClientIp.headerName()) {
                String clientIp;
                if (!Validate.hasText((CharSequence)headerName) || "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(headerName) || !Validate.hasText((CharSequence)(clientIp = request.getHeader(headerName)))) continue;
                return clientIp;
            }
        }
        return RequestUtils.getClientIp(request);
    }

    private static final class RequestClientIpNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private RequestClientIpNamedValueInfo(RequestClientIp annotation) {
            super(RequestClientIp.class.getName(), true, null);
        }
    }
}

