/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractContentTypeAnnotationHandler;
import com.buession.web.http.HttpHeader;
import com.buession.web.http.response.annotation.ContentType;
import com.buession.web.servlet.http.request.RequestUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class ServletContentTypeAnnotationHandler
extends AbstractContentTypeAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServletContentTypeAnnotationHandler.class);

    @Deprecated
    public ServletContentTypeAnnotationHandler() {
    }

    public ServletContentTypeAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, ContentType contentType) {
        HttpServletResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("HttpServletResponse is null");
            return;
        }
        StringBuilder sb = new StringBuilder(contentType.mime().length() + 24);
        if (this.stringValueResolver == null) {
            sb.append(contentType.mime());
        } else {
            sb.append(this.stringValueResolver.resolveStringValue(contentType.mime()));
        }
        if (Validate.isNotEmpty((CharSequence)contentType.encoding())) {
            sb.append("; charset=");
            if (this.stringValueResolver == null) {
                sb.append(contentType.encoding());
            } else {
                sb.append(this.stringValueResolver.resolveStringValue(contentType.encoding()));
            }
        }
        response.addHeader(HttpHeader.CONTENT_TYPE.getValue(), sb.toString());
    }
}

