/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractHttpCacheAnnotationHandler;
import com.buession.web.http.HttpHeader;
import com.buession.web.http.response.annotation.HttpCache;
import com.buession.web.servlet.http.request.RequestUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class ServletHttpCacheAnnotationHandler
extends AbstractHttpCacheAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServletHttpCacheAnnotationHandler.class);

    @Deprecated
    public ServletHttpCacheAnnotationHandler() {
    }

    public ServletHttpCacheAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, HttpCache httpCache) {
        HttpServletResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("HttpServletResponse is null");
            return;
        }
        boolean isSetCacheControl = false;
        if (Validate.hasText((CharSequence)httpCache.cacheControl())) {
            if (this.stringValueResolver == null) {
                response.setHeader(HttpHeader.CACHE_CONTROL.getValue(), httpCache.cacheControl());
            } else {
                response.setHeader(HttpHeader.CACHE_CONTROL.getValue(), this.stringValueResolver.resolveStringValue(httpCache.cacheControl()));
            }
            isSetCacheControl = true;
        }
        if (Validate.hasText((CharSequence)httpCache.expires())) {
            String expires;
            String string = expires = this.stringValueResolver == null ? httpCache.expires() : this.stringValueResolver.resolveStringValue(httpCache.expires());
            if (Validate.isNumeric((CharSequence)expires)) {
                response.setHeader(HttpHeader.EXPIRES.getValue(), expires);
                if (!isSetCacheControl) {
                    response.setHeader(HttpHeader.CACHE_CONTROL.getValue(), "max-age=" + expires);
                }
            }
        }
        if (Validate.hasText((CharSequence)httpCache.pragma())) {
            if (this.stringValueResolver == null) {
                response.setHeader(HttpHeader.PRAGMA.getValue(), httpCache.pragma());
            } else {
                response.setHeader(HttpHeader.PRAGMA.getValue(), this.stringValueResolver.resolveStringValue(httpCache.pragma()));
            }
        }
    }
}

