/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractResponseHeaderAnnotationHandler;
import com.buession.web.http.HttpHeader;
import com.buession.web.http.response.annotation.ResponseHeader;
import com.buession.web.servlet.http.request.RequestUtils;
import com.buession.web.servlet.http.response.ResponseUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class ServletResponseHeaderAnnotationHandler
extends AbstractResponseHeaderAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServletResponseHeaderAnnotationHandler.class);

    @Deprecated
    public ServletResponseHeaderAnnotationHandler() {
    }

    public ServletResponseHeaderAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, ResponseHeader responseHeader) {
        HttpServletResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("HttpServletResponse is null");
            return;
        }
        boolean isExpires = HttpHeader.EXPIRES.getValue().equalsIgnoreCase(responseHeader.name());
        for (String value : responseHeader.value()) {
            if (isExpires) {
                if (this.stringValueResolver != null) {
                    value = this.stringValueResolver.resolveStringValue(value);
                }
                if (Validate.isNumeric((CharSequence)value)) {
                    ResponseUtils.httpCache(response, Integer.parseInt(value));
                    continue;
                }
                ResponseUtils.httpCache(response, value);
                continue;
            }
            response.setHeader(responseHeader.name(), value);
        }
    }
}

