/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.aop.handler;

import com.buession.aop.MethodInvocation;
import com.buession.core.validator.Validate;
import com.buession.web.aop.handler.AbstractResponseHeadersAnnotationHandler;
import com.buession.web.http.HttpHeader;
import com.buession.web.http.response.annotation.ResponseHeaders;
import com.buession.web.servlet.http.request.RequestUtils;
import com.buession.web.servlet.http.response.ResponseUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class ServletResponseHeadersAnnotationHandler
extends AbstractResponseHeadersAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServletResponseHeadersAnnotationHandler.class);

    @Deprecated
    public ServletResponseHeadersAnnotationHandler() {
    }

    public ServletResponseHeadersAnnotationHandler(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    public void execute(MethodInvocation mi, ResponseHeaders responseHeaders) {
        Object[] headers = responseHeaders.value();
        if (Validate.isEmpty((Object[])headers)) {
            return;
        }
        HttpServletResponse response = RequestUtils.getResponse();
        if (response == null) {
            logger.warn("HttpServletResponse is null");
            return;
        }
        for (Object header : headers) {
            boolean isExpires = HttpHeader.EXPIRES.getValue().equalsIgnoreCase(header.name());
            for (String value : header.value()) {
                if (this.stringValueResolver != null) {
                    value = this.stringValueResolver.resolveStringValue(value);
                }
                if (isExpires) {
                    if (Validate.isNumeric((CharSequence)value)) {
                        ResponseUtils.httpCache(response, Integer.parseInt(value));
                        continue;
                    }
                    ResponseUtils.httpCache(response, value);
                    continue;
                }
                response.setHeader(header.name(), value);
            }
        }
    }
}

