/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.filter;

import com.buession.core.validator.Validate;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class PrintUrlFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(PrintUrlFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String url;
        if (logger.isInfoEnabled() && Validate.hasText((CharSequence)(url = this.parseFullUrl(request)))) {
            logger.info("Request URL: {}", (Object)url);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String parseUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    protected String parseFullUrl(HttpServletRequest request) {
        String queryString;
        String url = this.parseUrl(request);
        if (Validate.hasText((CharSequence)url) && Validate.hasText((CharSequence)(queryString = request.getQueryString()))) {
            url = url + '?' + queryString;
        }
        return url;
    }
}

