/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.filter;

import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponseHeaderFilter
extends OncePerRequestFilter {
    private String name;
    private String value;

    public ResponseHeaderFilter() {
    }

    public ResponseHeaderFilter(String name, String value) {
        this.setName(name);
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.isBlank((String)name, (String)"HTTP Response header name cloud not be empty or null");
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (Validate.hasText((CharSequence)this.getName())) {
            response.addHeader(this.getName(), this.getValue());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

