/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.http.request;

import com.buession.core.utils.Assert;
import com.buession.core.validator.Validate;
import com.buession.web.http.HttpHeader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils
extends com.buession.web.http.request.RequestUtils {
    private RequestUtils() {
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return attributes.getResponse();
    }

    public static String getClientIp(HttpServletRequest request) {
        Assert.isNull((Object)request, (String)"HttpServletRequest cloud not be null.");
        return RequestUtils.getClientIp(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0), request.getRemoteAddr());
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return RequestUtils.isAjaxRequest(request.getHeader(HttpHeader.X_REQUESTED_WITH.getValue()));
    }

    public static boolean isMobile(HttpServletRequest request) {
        return RequestUtils.isMobile(request.getHeader(HttpHeader.USER_AGENT.getValue()), request.getHeader(HttpHeader.ACCEPT.getValue()));
    }

    public static String getScheme(HttpServletRequest request) {
        String scheme = RequestUtils.getScheme(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0));
        return Validate.hasText((CharSequence)scheme) ? scheme : request.getScheme();
    }

    public static String getHost(HttpServletRequest request) {
        String host = RequestUtils.getHost(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0));
        return Validate.hasText((CharSequence)host) ? host : request.getServerName();
    }

    @Deprecated
    public static String getDomain(HttpServletRequest request) {
        return RequestUtils.getHost(request);
    }

    public static int getPort(HttpServletRequest request) {
        String forwardedPort = request.getHeader(HttpHeader.X_FORWARDED_PORT.getValue());
        return Validate.hasText((CharSequence)forwardedPort) ? Integer.parseInt(forwardedPort) : request.getServerPort();
    }

    public static String getAuthority(HttpServletRequest request) {
        String host = RequestUtils.getHost(request);
        return RequestUtils.getAuthority(RequestUtils.getScheme(request), host, host.contains(":") ? 0 : RequestUtils.getPort(request));
    }
}

