/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.servlet.http.response;

import com.buession.core.utils.ObjectUtils;
import com.buession.web.http.HttpHeader;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;

public class ResponseUtils {
    private ResponseUtils() {
    }

    public static void httpCache(HttpServletResponse response, String value) {
        ObjectUtils.invokeIfAvailable((Object)response, res -> res.setHeader(HttpHeader.CACHE_CONTROL.getValue(), value));
    }

    public static void httpCache(HttpServletResponse response, int lifetime) {
        ObjectUtils.invokeIfAvailable((Object)response, res -> {
            Date date = new Date(System.currentTimeMillis() + (long)lifetime * 1000L);
            ResponseUtils.httpCache(res, lifetime, date);
        });
    }

    public static void httpCache(HttpServletResponse response, Date date) {
        ObjectUtils.invokeIfAvailable((Object)response, res -> {
            long maxAge = date.getTime() - System.currentTimeMillis();
            ResponseUtils.httpCache(res, maxAge, date);
        });
    }

    private static void httpCache(HttpServletResponse response, long maxAge, Date expires) {
        response.setHeader(HttpHeader.CACHE_CONTROL.getValue(), maxAge < 0L ? "no-cache" : "max-age=" + maxAge);
        response.setDateHeader(HttpHeader.EXPIRES.getValue(), expires.getTime());
        response.setHeader(HttpHeader.PRAGMA.getValue(), maxAge > 0L ? null : "no-cache");
    }
}

