/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.utils.useragentutils;

import com.buession.core.validator.Validate;
import com.buession.web.utils.useragentutils.Browser;
import com.buession.web.utils.useragentutils.OperatingSystem;

public class UserAgent {
    private final OperatingSystem operatingSystem;
    private final Browser browser;

    public UserAgent(String userAgent) {
        if (Validate.hasText((CharSequence)userAgent)) {
            this.browser = Browser.parse(userAgent);
            this.operatingSystem = this.browser == Browser.BOT ? OperatingSystem.UNKNOWN : OperatingSystem.parse(userAgent);
        } else {
            this.operatingSystem = OperatingSystem.UNKNOWN;
            this.browser = Browser.UNKNOWN;
        }
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public String toString() {
        return this.operatingSystem.toString() + '-' + this.browser.toString();
    }
}

