/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.utils.useragentutils.versionfetcher;

import com.buession.lang.Version;
import com.buession.web.utils.useragentutils.versionfetcher.VersionFetcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternVersionFetcher
implements VersionFetcher {
    private final Pattern pattern;

    public PatternVersionFetcher(String regex) {
        this(Pattern.compile(regex, 2));
    }

    public PatternVersionFetcher(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public final Version fetch(String userAgent) {
        Matcher matcher = this.pattern.matcher(userAgent);
        return matcher.find() ? this.createVersion(matcher) : null;
    }

    protected Version createVersion(Matcher matcher) {
        String majorVersion = PatternVersionFetcher.removePeriod(matcher.group(2));
        String minorVersion = "0";
        String revisionVersion = null;
        String buildVersion = null;
        if (matcher.groupCount() > 2) {
            minorVersion = PatternVersionFetcher.removePeriod(matcher.group(3));
        }
        if (matcher.groupCount() > 3) {
            revisionVersion = PatternVersionFetcher.removePeriod(matcher.group(4));
        }
        if (revisionVersion == null) {
            return new Version(majorVersion, minorVersion);
        }
        if (matcher.groupCount() > 4) {
            buildVersion = PatternVersionFetcher.removePeriod(matcher.group(5));
        }
        if (buildVersion == null) {
            return new Version(majorVersion, minorVersion, revisionVersion);
        }
        return new Version(majorVersion, minorVersion, revisionVersion, buildVersion);
    }

    private static String removePeriod(String s) {
        if (s == null) {
            return null;
        }
        char c = s.charAt(0);
        return c == '.' || c == '_' ? s.substring(1) : s;
    }
}

