/*
 * Decompiled with CFR 0.152.
 */
package com.buession.web.utils.useragentutils.versionfetcher;

import com.buession.lang.Version;
import com.buession.web.utils.useragentutils.versionfetcher.VersionFetcher;

public class SequentialVersionFetcher
implements VersionFetcher {
    private final VersionFetcher[] fetchers;

    public SequentialVersionFetcher(VersionFetcher first, VersionFetcher ... others) {
        this.fetchers = new VersionFetcher[others.length + 1];
        this.fetchers[0] = first;
        for (int i = 0; i < others.length; ++i) {
            this.fetchers[i + 1] = others[i];
        }
    }

    @Override
    public Version fetch(String str) {
        for (VersionFetcher fetcher : this.fetchers) {
            Version version = (Version)fetcher.fetch(str);
            if (version == null) continue;
            return version;
        }
        return null;
    }
}

