/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.bugsnag.android.gradle.AndroidManifestInfo;
import com.bugsnag.android.gradle.AndroidManifestParser;
import com.bugsnag.android.gradle.AndroidManifestParser$findMetadataTags$;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import groovy.xml.Namespace;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\f\u001a\u0004\u0018\u00010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u0004\u0018\u00010\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0011\u001a\u0004\u0018\u00010\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bugsnag/android/gradle/AndroidManifestParser;", "", "()V", "namespace", "Lgroovy/xml/Namespace;", "findMetadataTags", "", "Lgroovy/util/Node;", "application", "getApplicationId", "", "xml", "getManifestMetaData", "metadataTags", "key", "getVersionCode", "metaDataTags", "getVersionName", "hasBuildUuid", "", "readManifest", "Lcom/bugsnag/android/gradle/AndroidManifestInfo;", "manifestPath", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "writeBuildUuid", "", "outputPath", "buildUuid", "Companion", "bugsnag-android-gradle-plugin"})
public final class AndroidManifestParser {
    private final Namespace namespace = new Namespace("http://schemas.android.com/apk/res/android", "android");
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_META_DATA = "meta-data";
    private static final String TAG_API_KEY = "com.bugsnag.android.API_KEY";
    private static final String TAG_BUILD_UUID = "com.bugsnag.android.BUILD_UUID";
    private static final String TAG_VERSION_CODE = "com.bugsnag.android.VERSION_CODE";
    private static final String TAG_APP_VERSION = "com.bugsnag.android.APP_VERSION";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_APPLICATION_ID = "package";
    private static final String ATTR_VERSION_CODE = "versionCode";
    private static final String ATTR_VERSION_NAME = "versionName";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AndroidManifestInfo readManifest(@NotNull File manifestPath, @NotNull Logger logger) {
        String applicationId;
        String versionName;
        String buildUUID;
        Intrinsics.checkParameterIsNotNull((Object)manifestPath, (String)"manifestPath");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        logger.debug("Bugsnag: Reading manifest at: " + manifestPath);
        Node root = new XmlParser().parse(manifestPath);
        Object object = root.get(TAG_APPLICATION);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type groovy.util.NodeList");
        }
        Object object2 = ((NodeList)object).get(0);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type groovy.util.Node");
        }
        Node application = (Node)object2;
        List<Node> metadataTags = this.findMetadataTags(application);
        String apiKey = this.getManifestMetaData(metadataTags, TAG_API_KEY);
        if (apiKey == null) {
            logger.warn("Bugsnag: Could not find apiKey in 'com.bugsnag.android.API_KEY' <meta-data> tag in your AndroidManifest.xml");
        }
        Node node = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"root");
        String versionCode = this.getVersionCode(metadataTags, node);
        if (versionCode == null) {
            logger.warn("Bugsnag: Could not find 'android:versionCode' value in your AndroidManifest.xml");
        }
        if ((buildUUID = this.getManifestMetaData(metadataTags, TAG_BUILD_UUID)) == null) {
            logger.warn("Bugsnag: Could not find 'com.bugsnag.android.BUILD_UUID' <meta-data> tag in your AndroidManifest.xml");
        }
        if ((versionName = this.getVersionName(metadataTags, root)) == null) {
            logger.warn("Bugsnag: Could not find 'android:versionName' value in your AndroidManifest.xml");
        }
        if ((applicationId = this.getApplicationId(root)) == null) {
            logger.warn("Bugsnag: Could not find 'package' value in your AndroidManifest.xml");
        }
        if (apiKey == null || Intrinsics.areEqual((Object)"", (Object)apiKey) || versionCode == null || buildUUID == null || versionName == null || applicationId == null) {
            throw (Throwable)new IllegalStateException(StringsKt.trimMargin$default((String)("Bugsnag: Missing apiKey/versionCode/buildUuid/versionName/package, required to upload to bugsnag.\n                    |apiKey=" + apiKey + "\n                    |versionCode=" + versionCode + "\n                    |buildUUID=" + buildUUID + "\n                    |versionName=" + versionName + "\n                    |applicationId=" + applicationId + "\n                    |Manifest file = " + manifestPath + "\n                "), null, (int)1, null));
        }
        return new AndroidManifestInfo(apiKey, versionCode, buildUUID, versionName, applicationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBuildUuid(@NotNull File manifestPath, @NotNull File outputPath, @NotNull String buildUuid) throws ParserConfigurationException, SAXException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)manifestPath, (String)"manifestPath");
        Intrinsics.checkParameterIsNotNull((Object)outputPath, (String)"outputPath");
        Intrinsics.checkParameterIsNotNull((Object)buildUuid, (String)"buildUuid");
        Node root = new XmlParser().parse(manifestPath);
        Object object = root.get(TAG_APPLICATION);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type groovy.util.NodeList");
        }
        Object object2 = ((NodeList)object).get(0);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type groovy.util.Node");
        }
        Node application = (Node)object2;
        List<Node> metadataTags = this.findMetadataTags(application);
        if (!this.hasBuildUuid(metadataTags)) {
            application.appendNode((Object)TAG_META_DATA, (Map)MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)this.namespace.get(ATTR_NAME), (Object)TAG_BUILD_UUID), TuplesKt.to((Object)this.namespace.get(ATTR_VALUE), (Object)buildUuid)}));
        }
        Closeable closeable = new FileWriter(outputPath);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            boolean bl2 = false;
            XmlNodePrinter printer = new XmlNodePrinter(new PrintWriter(it));
            printer.setPreserveWhitespace(true);
            printer.print(root);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeBuildUuid$default(AndroidManifestParser androidManifestParser, File file, File file2, String string, int n, Object object) throws ParserConfigurationException, SAXException, IOException {
        if ((n & 2) != 0) {
            file2 = file;
        }
        androidManifestParser.writeBuildUuid(file, file2, string);
    }

    private final List<Node> findMetadataTags(Node application) {
        List list = application.children();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"application.children()");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findMetadataTags$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)findMetadataTags.1.INSTANCE));
    }

    private final boolean hasBuildUuid(List<? extends Node> metadataTags) {
        return this.getManifestMetaData(metadataTags, TAG_BUILD_UUID) != null;
    }

    private final String getManifestMetaData(List<? extends Node> metadataTags, String key) {
        Node node;
        Object v0;
        block1: {
            Iterable iterable = metadataTags;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Node it = (Node)t;
                boolean bl3 = false;
                Object name = it.attribute((Object)this.namespace.get(ATTR_NAME));
                if (!Intrinsics.areEqual((Object)key, (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Node node2 = node = (Node)v0;
        return (String)(node2 != null ? node2.attribute((Object)this.namespace.get(ATTR_VALUE)) : null);
    }

    private final String getVersionName(List<? extends Node> metaDataTags, Node xml) {
        String versionName = this.getManifestMetaData(metaDataTags, TAG_APP_VERSION);
        String string = versionName;
        if (string == null) {
            string = (String)xml.attribute((Object)this.namespace.get(ATTR_VERSION_NAME));
        }
        return string;
    }

    private final String getVersionCode(List<? extends Node> metaDataTags, Node xml) {
        String versionCode = this.getManifestMetaData(metaDataTags, TAG_VERSION_CODE);
        String string = versionCode;
        if (string == null) {
            string = (String)xml.attribute((Object)this.namespace.get(ATTR_VERSION_CODE));
        }
        return string;
    }

    private final String getApplicationId(Node xml) {
        return (String)xml.attribute((Object)ATTR_APPLICATION_ID);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bugsnag/android/gradle/AndroidManifestParser$Companion;", "", "()V", "ATTR_APPLICATION_ID", "", "ATTR_NAME", "ATTR_VALUE", "ATTR_VERSION_CODE", "ATTR_VERSION_NAME", "TAG_API_KEY", "TAG_APPLICATION", "TAG_APP_VERSION", "TAG_BUILD_UUID", "TAG_META_DATA", "TAG_VERSION_CODE", "bugsnag-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

