/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.bugsnag.android.gradle.AndroidManifestInfo;
import com.bugsnag.android.gradle.BugsnagFileUploadTask;
import com.bugsnag.android.gradle.internal.BugsnagHttpClientHelper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\nH\u0002J\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bugsnag/android/gradle/BugsnagMultiPartUploadRequest;", "", "logger", "Lorg/gradle/api/logging/Logger;", "failOnUploadError", "", "overwrite", "endpoint", "", "retryCount", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lorg/gradle/api/logging/Logger;ZZLjava/lang/String;ILokhttp3/OkHttpClient;)V", "getRetryCount", "uploadMultipartEntity", "manifestInfo", "Lcom/bugsnag/android/gradle/AndroidManifestInfo;", "action", "Lkotlin/Function1;", "Lokhttp3/MultipartBody$Builder;", "", "uploadToServer", "body", "Lokhttp3/MultipartBody;", "Companion", "bugsnag-android-gradle-plugin"})
public final class BugsnagMultiPartUploadRequest {
    private final Logger logger;
    private final boolean failOnUploadError;
    private final boolean overwrite;
    private final String endpoint;
    private final int retryCount;
    private final OkHttpClient okHttpClient;
    public static final int MAX_RETRY_COUNT = 5;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String uploadMultipartEntity(@NotNull AndroidManifestInfo manifestInfo, @NotNull Function1<? super MultipartBody.Builder, Unit> action) {
        int maxRetryCount;
        Intrinsics.checkParameterIsNotNull((Object)manifestInfo, (String)"manifestInfo");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        MultipartBody.Builder builder = Companion.buildMultipartBody$bugsnag_android_gradle_plugin(manifestInfo, this.overwrite);
        action.invoke((Object)builder);
        MultipartBody body = builder.build();
        String response2 = this.uploadToServer(body);
        boolean uploadSuccessful = response2 != null;
        for (int retryCount = maxRetryCount = this.getRetryCount(); !uploadSuccessful && retryCount > 0; --retryCount) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Bugsnag: Retrying upload (%d/%d) ...";
            Object[] objectArray = new Object[]{maxRetryCount - retryCount + 1, maxRetryCount};
            Logger logger = this.logger;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            logger.warn(string);
            response2 = this.uploadToServer(body);
            uploadSuccessful = response2 != null;
        }
        if (!uploadSuccessful && this.failOnUploadError) {
            throw (Throwable)new GradleException("Upload did not succeed");
        }
        String string = response2;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String uploadToServer(MultipartBody body) {
        Request request = new Request.Builder().url(this.endpoint).post((RequestBody)body).build();
        Closeable closeable = (Closeable)this.okHttpClient.newCall(request).execute();
        boolean bl = false;
        Throwable throwable = null;
        try {
            Response response2 = (Response)closeable;
            boolean bl2 = false;
            if (!response2.isSuccessful()) {
                throw (Throwable)new IOException("Bugsnag upload failed with code " + response2.code());
            }
            ResponseBody responseBody = response2.body();
            String string = responseBody != null ? responseBody.string() : null;
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final int getRetryCount() {
        return this.retryCount >= 5 ? 5 : this.retryCount;
    }

    public BugsnagMultiPartUploadRequest(@NotNull Logger logger, boolean failOnUploadError, boolean overwrite, @NotNull String endpoint, int retryCount, @NotNull OkHttpClient okHttpClient2) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient2, (String)"okHttpClient");
        this.logger = logger;
        this.failOnUploadError = failOnUploadError;
        this.overwrite = overwrite;
        this.endpoint = endpoint;
        this.retryCount = retryCount;
        this.okHttpClient = okHttpClient2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ%\u0010\f\u001a\u00020\r\"\f\b\u0000\u0010\u000e*\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u000eH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bugsnag/android/gradle/BugsnagMultiPartUploadRequest$Companion;", "", "()V", "MAX_RETRY_COUNT", "", "buildMultipartBody", "Lokhttp3/MultipartBody$Builder;", "manifestInfo", "Lcom/bugsnag/android/gradle/AndroidManifestInfo;", "overwrite", "", "buildMultipartBody$bugsnag_android_gradle_plugin", "from", "Lcom/bugsnag/android/gradle/BugsnagMultiPartUploadRequest;", "T", "Lorg/gradle/api/DefaultTask;", "Lcom/bugsnag/android/gradle/BugsnagFileUploadTask;", "task", "from$bugsnag_android_gradle_plugin", "(Lorg/gradle/api/DefaultTask;)Lcom/bugsnag/android/gradle/BugsnagMultiPartUploadRequest;", "bugsnag-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final MultipartBody.Builder buildMultipartBody$bugsnag_android_gradle_plugin(@NotNull AndroidManifestInfo manifestInfo, boolean overwrite) {
            Intrinsics.checkParameterIsNotNull((Object)manifestInfo, (String)"manifestInfo");
            MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("apiKey", manifestInfo.getApiKey()).addFormDataPart("appId", manifestInfo.getApplicationId()).addFormDataPart("versionCode", manifestInfo.getVersionCode()).addFormDataPart("buildUUID", manifestInfo.getBuildUUID()).addFormDataPart("versionName", manifestInfo.getVersionName());
            if (overwrite) {
                builder.addFormDataPart("overwrite", "true");
            }
            return builder;
        }

        @NotNull
        public final <T extends DefaultTask> BugsnagMultiPartUploadRequest from$bugsnag_android_gradle_plugin(@NotNull T task) {
            Intrinsics.checkParameterIsNotNull(task, (String)"task");
            Logger logger = task.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"task.logger");
            Object object = ((BugsnagFileUploadTask)task).getFailOnUploadError().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.failOnUploadError.get()");
            boolean bl = (Boolean)object;
            Object object2 = ((BugsnagFileUploadTask)task).getOverwrite().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"task.overwrite.get()");
            boolean bl2 = (Boolean)object2;
            Object object3 = ((BugsnagFileUploadTask)task).getEndpoint().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"task.endpoint.get()");
            String string = (String)object3;
            Object object4 = ((BugsnagFileUploadTask)task).getRetryCount().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"task.retryCount.get()");
            return new BugsnagMultiPartUploadRequest(logger, bl, bl2, string, ((Number)object4).intValue(), ((BugsnagHttpClientHelper)((BugsnagFileUploadTask)task).getHttpClientHelper().get()).getOkHttpClient());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

