/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.ApkVariantOutput;
import com.bugsnag.android.gradle.MappingFileProviderKt;
import com.bugsnag.android.gradle.internal.GradleUtilKt;
import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"createMappingFileProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/ApkVariant;", "variantOutput", "Lcom/android/build/gradle/api/ApkVariantOutput;", "android", "Lcom/android/build/gradle/AppExtension;", "findDexguardMappingFile", "Ljava/io/File;", "findMappingFiles", "bugsnag-android-gradle-plugin"})
public final class MappingFileProviderKt {
    @NotNull
    public static final Provider<FileCollection> createMappingFileProvider(@NotNull Project project, @NotNull ApkVariant variant, @NotNull ApkVariantOutput variantOutput, @NotNull AppExtension android) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)variantOutput, (String)"variantOutput");
        Intrinsics.checkParameterIsNotNull((Object)android, (String)"android");
        Provider provider = MappingFileProviderKt.findMappingFiles(project, variant, variantOutput, android).map((Transformer)createMappingFileProvider.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"findMappingFiles(project\u2026.filter { it.exists() } }");
        return provider;
    }

    private static final Provider<FileCollection> findMappingFiles(Project project, ApkVariant variant, ApkVariantOutput variantOutput, AppExtension android) {
        Provider provider;
        if (GradleUtilKt.hasDexguardPlugin(project) && GradleUtilKt.hasMultipleOutputs(android)) {
            File mappingFile = MappingFileProviderKt.findDexguardMappingFile(project, variant, variantOutput);
            if (mappingFile.exists()) {
                Provider provider2 = project.provider((Callable)new Callable<FileCollection>(project, mappingFile){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ File $mappingFile;

                    public final FileCollection call() {
                        return this.$project.getLayout().files(new Object[]{this.$mappingFile});
                    }
                    {
                        this.$project = project;
                        this.$mappingFile = file;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"project.provider { proje\u2026yout.files(mappingFile) }");
                return provider2;
            }
            project.getLogger().warn("Bugsnag: Could not find DexGuard mapping file at: " + mappingFile + " -" + " falling back to AGP mapping file value");
        }
        try {
            Provider provider3 = variant.getMappingFileProvider();
            Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"variant.mappingFileProvider");
            provider = provider3;
        }
        catch (Throwable exc) {
            Provider provider4 = project.provider((Callable)new Callable<FileCollection>(project, variant){
                final /* synthetic */ Project $project;
                final /* synthetic */ ApkVariant $variant;

                public final FileCollection call() {
                    return this.$project.getLayout().files(new Object[]{this.$variant.getMappingFile()});
                }
                {
                    this.$project = project;
                    this.$variant = apkVariant;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)provider4, (String)"project.provider { proje\u2026es(variant.mappingFile) }");
            provider = provider4;
        }
        return provider;
    }

    private static final File findDexguardMappingFile(Project project, ApkVariant variant, ApkVariantOutput variantOutput) {
        String string = project.getBuildDir().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.buildDir.toString()");
        String buildDir = string;
        String outputDir = variantOutput.getDirName();
        String string2 = variantOutput.getDirName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variantOutput.dirName");
        if (StringsKt.endsWith$default((String)string2, (String)("dpi" + File.separator), (boolean)false, (int)2, null) && (outputDir = new File(variantOutput.getDirName()).getParent()) == null) {
            outputDir = "";
        }
        File file = Paths.get(buildDir, "outputs", "mapping", variant.getDirName(), outputDir, "mapping.txt").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(buildDir, \"out\u2026, \"mapping.txt\").toFile()");
        return file;
    }
}

