/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle.internal;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0000\u00a8\u0006\n"}, d2={"newClient", "Lokhttp3/OkHttpClient;", "timeoutMillis", "", "runRequestWithRetries", "", "maxRetries", "", "request", "Lkotlin/Function0;", "bugsnag-android-gradle-plugin"})
public final class BugsnagHttpClientHelperKt {
    @NotNull
    public static final OkHttpClient newClient(long timeoutMillis) {
        Duration timeoutDuration = Duration.ofMillis(timeoutMillis);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Duration duration = timeoutDuration;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"timeoutDuration");
        OkHttpClient.Builder builder2 = builder.readTimeout(duration).writeTimeout(timeoutDuration).connectTimeout(timeoutDuration);
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
        return builder2.callTimeout(duration2).build();
    }

    @NotNull
    public static final String runRequestWithRetries(int maxRetries, @NotNull Function0<String> request) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        int attempts = 0;
        Throwable cause = null;
        while (true) {
            try {
                return (String)request.invoke();
            }
            catch (Throwable exc) {
                cause = exc;
                if (++attempts < maxRetries) continue;
                throw (Throwable)new IllegalStateException("Bugsnag request failed to complete", cause);
            }
            break;
        }
    }
}

