/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle.internal;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.bugsnag.android.gradle.GroovyCompat;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver.Version;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0003H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0015"}, d2={"findDexguardMappingFile", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "variantOutput", "Lcom/android/build/gradle/api/BaseVariantOutput;", "path", "", "", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/api/BaseVariant;Lcom/android/build/gradle/api/BaseVariantOutput;[Ljava/lang/String;)Ljava/io/File;", "findMappingFileDexguard9", "", "findMappingFileDexguardLegacy", "getDexguardAabTaskName", "getDexguardVersion", "Lorg/semver/Version;", "hasDexguardPlugin", "", "isDexguardEnabledForVariant", "bugsnag-android-gradle-plugin"})
public final class DexguardCompatKt {
    @NotNull
    public static final List<File> findMappingFileDexguard9(@NotNull Project project, @NotNull BaseVariant variant, @NotNull BaseVariantOutput variantOutput) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)variantOutput, (String)"variantOutput");
        Object[] objectArray = new File[2];
        String[] stringArray = new String[]{"outputs", "dexguard", "mapping", "apk"};
        objectArray[0] = DexguardCompatKt.findDexguardMappingFile(project, variant, variantOutput, stringArray);
        stringArray = new String[]{"outputs", "dexguard", "mapping", "bundle"};
        objectArray[1] = DexguardCompatKt.findDexguardMappingFile(project, variant, variantOutput, stringArray);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final File findMappingFileDexguardLegacy(@NotNull Project project, @NotNull BaseVariant variant, @NotNull BaseVariantOutput variantOutput) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)variantOutput, (String)"variantOutput");
        String[] stringArray = new String[]{"outputs", "mapping"};
        return DexguardCompatKt.findDexguardMappingFile(project, variant, variantOutput, stringArray);
    }

    private static final File findDexguardMappingFile(Project project, BaseVariant variant, BaseVariantOutput variantOutput, String[] path) {
        String string = project.getBuildDir().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.buildDir.toString()");
        String buildDir = string;
        String outputDir = variantOutput.getDirName();
        if (Intrinsics.areEqual((Object)path[path.length - 1], (Object)"bundle")) {
            outputDir = "";
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.addSpread((Object)path);
        spreadBuilder.add((Object)variant.getDirName());
        spreadBuilder.add((Object)outputDir);
        spreadBuilder.add((Object)"mapping.txt");
        File file = Paths.get(buildDir, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(buildDir, *path, var\u2026, \"mapping.txt\").toFile()");
        return file;
    }

    public static final boolean hasDexguardPlugin(@NotNull Project $this$hasDexguardPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDexguardPlugin, (String)"<this>");
        return $this$hasDexguardPlugin.getPluginManager().hasPlugin("dexguard");
    }

    public static final boolean isDexguardEnabledForVariant(@NotNull Project $this$isDexguardEnabledForVariant, @NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)$this$isDexguardEnabledForVariant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        String flavor = variant.getFlavorName();
        Intrinsics.checkNotNullExpressionValue((Object)flavor, (String)"flavor");
        String buildType = ((CharSequence)flavor).length() == 0 ? variant.getBuildType().getName() : StringsKt.capitalize((String)variant.getBuildType().getName());
        return GroovyCompat.isDexguardEnabledForVariant($this$isDexguardEnabledForVariant.getProject(), flavor + buildType);
    }

    @Nullable
    public static final Version getDexguardVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = GroovyCompat.getDexguardVersionString(project);
        if (string == null) {
            return null;
        }
        String version = string;
        return Version.parse((String)version);
    }

    @NotNull
    public static final String getDexguardAabTaskName(@NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        String buildType = StringsKt.capitalize((String)variant.getBuildType().getName());
        String string = variant.getFlavorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.flavorName");
        String flavor = StringsKt.capitalize((String)string);
        return "dexguardAab" + flavor + buildType;
    }
}

