/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Bugsnag;
import com.bugsnag.HandledState;
import com.bugsnag.Severity;
import java.lang.reflect.Method;
import java.util.Collections;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;

public class BugsnagAsyncExceptionHandler
implements AsyncUncaughtExceptionHandler {
    private final Bugsnag bugsnag;

    public BugsnagAsyncExceptionHandler(Bugsnag bugsnag) {
        this.bugsnag = bugsnag;
    }

    public void handleUncaughtException(Throwable throwable, Method method, Object ... obj) {
        if (this.bugsnag.getConfig().shouldSendUncaughtExceptions()) {
            HandledState handledState = HandledState.newInstance((HandledState.SeverityReasonType)HandledState.SeverityReasonType.REASON_UNHANDLED_EXCEPTION_MIDDLEWARE, Collections.singletonMap("framework", "Spring"), (Severity)Severity.ERROR, (boolean)true);
            this.bugsnag.notify(throwable, handledState, Thread.currentThread());
        }
    }
}

