/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.SpringVersion;
import org.springframework.core.type.AnnotationMetadata;

public class BugsnagImportSelector
implements ImportSelector {
    private static final String[] SPRING_JAKARTA_CLASSES = new String[]{"com.bugsnag.SpringBootJakartaConfiguration", "com.bugsnag.JakartaMvcConfiguration", "com.bugsnag.ScheduledTaskConfiguration"};
    private static final String[] SPRING_JAVAX_CLASSES = new String[]{"com.bugsnag.SpringBootJavaxConfiguration", "com.bugsnag.JavaxMvcConfiguration", "com.bugsnag.ScheduledTaskConfiguration"};

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        if (BugsnagImportSelector.isSpringJakartaCompatible() && BugsnagImportSelector.isJava17Compatible()) {
            return SPRING_JAKARTA_CLASSES;
        }
        return SPRING_JAVAX_CLASSES;
    }

    private static boolean isSpringJakartaCompatible() {
        return BugsnagImportSelector.getMajorVersion(SpringVersion.getVersion()) >= 6;
    }

    private static boolean isJava17Compatible() {
        return BugsnagImportSelector.getMajorVersion(System.getProperty("java.version")) >= 17;
    }

    private static int getMajorVersion(String version) {
        if (version == null) {
            return 0;
        }
        int firstDot = version.indexOf(".");
        String majorVersion = firstDot == -1 ? version : version.substring(0, firstDot);
        try {
            return Integer.parseInt(majorVersion);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

