/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Bugsnag;
import com.bugsnag.HandledState;
import com.bugsnag.Severity;
import java.util.Collections;
import org.springframework.util.ErrorHandler;

class BugsnagScheduledTaskExceptionHandler
implements ErrorHandler {
    private final Bugsnag bugsnag;
    private volatile ErrorHandler existingErrorHandler;

    BugsnagScheduledTaskExceptionHandler(Bugsnag bugsnag) {
        this.bugsnag = bugsnag;
    }

    public void handleError(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (this.bugsnag.getConfig().shouldSendUncaughtExceptions()) {
            HandledState handledState = HandledState.newInstance((HandledState.SeverityReasonType)HandledState.SeverityReasonType.REASON_UNHANDLED_EXCEPTION_MIDDLEWARE, Collections.singletonMap("framework", "Spring"), (Severity)Severity.ERROR, (boolean)true);
            this.bugsnag.notify(throwable, handledState, Thread.currentThread());
        }
        if (this.existingErrorHandler != null && !(this.existingErrorHandler instanceof BugsnagScheduledTaskExceptionHandler)) {
            this.existingErrorHandler.handleError(throwable);
        }
    }

    void setExistingErrorHandler(ErrorHandler existingErrorHandler) {
        this.existingErrorHandler = existingErrorHandler;
    }
}

