/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.BeforeSendSession;
import com.bugsnag.Bugsnag;
import com.bugsnag.BugsnagAppender;
import com.bugsnag.BugsnagImportSelector;
import com.bugsnag.Diagnostics;
import com.bugsnag.Report;
import com.bugsnag.ScheduledTaskBeanLocator;
import com.bugsnag.SessionPayload;
import com.bugsnag.callbacks.Callback;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.SpringVersion;

@Configuration
@Import(value={BugsnagImportSelector.class})
public class BugsnagSpringConfiguration
implements InitializingBean {
    @Autowired
    private Bugsnag bugsnag;

    @Bean
    Callback springVersionErrorCallback() {
        Callback callback = new Callback(){

            public void beforeNotify(Report report) {
                BugsnagSpringConfiguration.this.addSpringRuntimeVersion(report.getDevice());
            }
        };
        this.bugsnag.addCallback(callback);
        return callback;
    }

    @Bean
    BeforeSendSession springVersionSessionCallback() {
        BeforeSendSession beforeSendSession = new BeforeSendSession(){

            public void beforeSendSession(SessionPayload payload) {
                BugsnagSpringConfiguration.this.addSpringRuntimeVersion(payload.getDevice());
            }
        };
        this.bugsnag.addBeforeSendSession(beforeSendSession);
        return beforeSendSession;
    }

    private void addSpringRuntimeVersion(Map<String, Object> device) {
        Diagnostics.addDeviceRuntimeVersion(device, (String)"springFramework", (Object)SpringVersion.getVersion());
    }

    @Bean
    ScheduledTaskBeanLocator scheduledTaskBeanLocator() {
        return new ScheduledTaskBeanLocator();
    }

    public void afterPropertiesSet() {
        try {
            BugsnagAppender.addExcludedLoggerPattern((String)"org.apache.catalina.core.ContainerBase.\\[Tomcat.*\\][.]\\[.*\\][.]\\[/.*\\][.]\\[.*\\]");
            BugsnagAppender.addExcludedLoggerPattern((String)"org.eclipse.jetty.server.HttpChannel");
            BugsnagAppender.addExcludedLoggerPattern((String)"io.undertow.request");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

