/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.HandledState;
import com.bugsnag.Report;
import com.bugsnag.Severity;
import com.bugsnag.callbacks.Callback;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

class ExceptionClassCallback
implements Callback {
    private static final Map<Class<? extends Exception>, Severity> EXCEPTION_TO_SEVERITY = new HashMap<Class<? extends Exception>, Severity>();

    ExceptionClassCallback() {
    }

    public void beforeNotify(Report report) {
        HandledState handledState = report.getHandledState();
        HandledState.SeverityReasonType severityReasonType = handledState.calculateSeverityReasonType();
        if (severityReasonType == HandledState.SeverityReasonType.REASON_USER_SPECIFIED || severityReasonType == HandledState.SeverityReasonType.REASON_CALLBACK_SPECIFIED) {
            return;
        }
        Class<?> exceptionClass = report.getException().getClass();
        if (EXCEPTION_TO_SEVERITY.containsKey(exceptionClass)) {
            Severity severity = EXCEPTION_TO_SEVERITY.get(exceptionClass);
            report.setSeverity(severity);
            report.setHandledState(HandledState.newInstance((HandledState.SeverityReasonType)HandledState.SeverityReasonType.REASON_EXCEPTION_CLASS, Collections.singletonMap("exceptionClass", exceptionClass.getSimpleName()), (Severity)severity, (boolean)handledState.isUnhandled()));
        }
    }

    static {
        EXCEPTION_TO_SEVERITY.put(ServletRequestBindingException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(HttpRequestMethodNotSupportedException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(HttpMediaTypeNotSupportedException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(HttpMediaTypeNotAcceptableException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(MethodArgumentNotValidException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(MissingServletRequestPartException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(BindException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(NoHandlerFoundException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(ConversionNotSupportedException.class, Severity.ERROR);
        EXCEPTION_TO_SEVERITY.put(TypeMismatchException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(HttpMessageNotReadableException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(HttpMessageNotWritableException.class, Severity.ERROR);
        EXCEPTION_TO_SEVERITY.put(MissingServletRequestParameterException.class, Severity.INFO);
        EXCEPTION_TO_SEVERITY.put(MissingPathVariableException.class, Severity.ERROR);
    }
}

