/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.TaskScheduler;

class ScheduledTaskBeanLocator
implements ApplicationContextAware {
    private ApplicationContext beanFactory;

    ScheduledTaskBeanLocator() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
    }

    TaskScheduler resolveTaskScheduler() {
        return this.resolveSchedulerBean(TaskScheduler.class);
    }

    ScheduledExecutorService resolveScheduledExecutorService() {
        return this.resolveSchedulerBean(ScheduledExecutorService.class);
    }

    private <T> T resolveSchedulerBean(Class<T> schedulerType) {
        try {
            return this.resolveSchedulerBeanByType(schedulerType);
        }
        catch (NoUniqueBeanDefinitionException ex) {
            return this.resolveSchedulerBeanByName(schedulerType);
        }
        catch (NoSuchBeanDefinitionException ex2) {
            return null;
        }
    }

    private <T> T resolveSchedulerBeanByType(Class<T> schedulerType) {
        if (this.beanFactory instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory factory = (AutowireCapableBeanFactory)this.beanFactory;
            NamedBeanHolder holder = factory.resolveNamedBean(schedulerType);
            return (T)holder.getBeanInstance();
        }
        return (T)this.beanFactory.getBean(schedulerType);
    }

    private <T> T resolveSchedulerBeanByName(Class<T> schedulerType) {
        try {
            return (T)this.beanFactory.getBean("taskScheduler", schedulerType);
        }
        catch (NoSuchBeanDefinitionException exc) {
            return null;
        }
        catch (BeanNotOfRequiredTypeException exc) {
            return null;
        }
    }
}

