/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Bugsnag;
import com.bugsnag.BugsnagScheduledTaskExceptionHandler;
import com.bugsnag.ScheduledTaskBeanLocator;
import java.lang.reflect.Field;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.ErrorHandler;

@Configuration
class ScheduledTaskConfiguration
implements SchedulingConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledTaskConfiguration.class);
    @Autowired
    private Bugsnag bugsnag;
    @Autowired
    private ScheduledTaskBeanLocator beanLocator;

    ScheduledTaskConfiguration() {
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        TaskScheduler taskScheduler;
        BugsnagScheduledTaskExceptionHandler bugsnagErrorHandler = new BugsnagScheduledTaskExceptionHandler(this.bugsnag);
        TaskScheduler registrarScheduler = taskRegistrar.getScheduler();
        TaskScheduler taskScheduler2 = taskScheduler = registrarScheduler != null ? registrarScheduler : this.beanLocator.resolveTaskScheduler();
        if (taskScheduler != null) {
            Class targetClass;
            if (AopUtils.isAopProxy((Object)taskScheduler) && TaskScheduler.class.isAssignableFrom(targetClass = AopProxyUtils.ultimateTargetClass((Object)taskScheduler))) {
                taskScheduler = (TaskScheduler)AopProxyUtils.getSingletonTarget((Object)taskScheduler);
            }
            this.configureExistingTaskScheduler(taskScheduler, bugsnagErrorHandler);
        } else {
            ScheduledExecutorService executorService = this.beanLocator.resolveScheduledExecutorService();
            taskScheduler = this.createNewTaskScheduler(executorService, bugsnagErrorHandler);
            taskRegistrar.setScheduler((Object)taskScheduler);
        }
    }

    private TaskScheduler createNewTaskScheduler(ScheduledExecutorService executorService, BugsnagScheduledTaskExceptionHandler errorHandler) {
        if (executorService != null) {
            ConcurrentTaskScheduler scheduler = new ConcurrentTaskScheduler(executorService);
            scheduler.setErrorHandler((ErrorHandler)errorHandler);
            return scheduler;
        }
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setErrorHandler((ErrorHandler)errorHandler);
        scheduler.initialize();
        return scheduler;
    }

    private void configureExistingTaskScheduler(TaskScheduler taskScheduler, BugsnagScheduledTaskExceptionHandler errorHandler) {
        try {
            Field errorHandlerField = taskScheduler.getClass().getDeclaredField("errorHandler");
            errorHandlerField.setAccessible(true);
            Object existingErrorHandler = errorHandlerField.get(taskScheduler);
            if (existingErrorHandler instanceof ErrorHandler) {
                errorHandler.setExistingErrorHandler((ErrorHandler)existingErrorHandler);
            }
            errorHandlerField.set(taskScheduler, errorHandler);
        }
        catch (Throwable ex) {
            LOGGER.warn("Bugsnag scheduled task exception handler could not be configured");
        }
    }
}

